/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.tx.TxMappingType;
import org.apache.ignite.internal.management.tx.TxVerboseKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class TxVerboseInfo
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private GridCacheVersion nearXidVer;
    private UUID locNodeId;
    private Object locNodeConsistentId;
    private UUID nearNodeId;
    private Object nearNodeConsistentId;
    private TxMappingType txMappingType;
    private UUID dhtNodeId;
    private Object dhtNodeConsistentId;
    private Map<Integer, String> usedCaches;
    private Map<Integer, String> usedCacheGroups;
    private List<TxVerboseKey> locTxKeys;
    private List<TxVerboseKey> nearOnlyTxKeys;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.nearXidVer);
        U.writeUuid(out, this.locNodeId);
        out.writeObject(this.locNodeConsistentId);
        U.writeUuid(out, this.nearNodeId);
        out.writeObject(this.nearNodeConsistentId);
        U.writeEnum(out, this.txMappingType);
        U.writeUuid(out, this.dhtNodeId);
        out.writeObject(this.dhtNodeConsistentId);
        U.writeMap(out, this.usedCaches);
        U.writeMap(out, this.usedCacheGroups);
        U.writeCollection(out, this.locTxKeys);
        U.writeCollection(out, this.nearOnlyTxKeys);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nearXidVer = (GridCacheVersion)in.readObject();
        this.locNodeId = U.readUuid(in);
        this.locNodeConsistentId = in.readObject();
        this.nearNodeId = U.readUuid(in);
        this.nearNodeConsistentId = in.readObject();
        this.txMappingType = TxMappingType.fromOrdinal(in.readByte());
        this.dhtNodeId = U.readUuid(in);
        this.dhtNodeConsistentId = in.readObject();
        this.usedCaches = U.readHashMap(in);
        this.usedCacheGroups = U.readHashMap(in);
        this.locTxKeys = U.readList(in);
        this.nearOnlyTxKeys = U.readList(in);
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public void nearXidVersion(GridCacheVersion nearXidVer) {
        this.nearXidVer = nearXidVer;
    }

    public UUID localNodeId() {
        return this.locNodeId;
    }

    public void localNodeId(UUID locNodeId) {
        this.locNodeId = locNodeId;
    }

    public Object localNodeConsistentId() {
        return this.locNodeConsistentId;
    }

    public void localNodeConsistentId(Object locNodeConsistentId) {
        this.locNodeConsistentId = locNodeConsistentId;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public void nearNodeId(UUID nearNodeId) {
        this.nearNodeId = nearNodeId;
    }

    public Object nearNodeConsistentId() {
        return this.nearNodeConsistentId;
    }

    public void nearNodeConsistentId(Object nearNodeConsistentId) {
        this.nearNodeConsistentId = nearNodeConsistentId;
    }

    public TxMappingType txMappingType() {
        return this.txMappingType;
    }

    public void txMappingType(TxMappingType txMappingType) {
        this.txMappingType = txMappingType;
    }

    public UUID dhtNodeId() {
        return this.dhtNodeId;
    }

    public void dhtNodeId(UUID dhtNodeId) {
        this.dhtNodeId = dhtNodeId;
    }

    public Object dhtNodeConsistentId() {
        return this.dhtNodeConsistentId;
    }

    public void dhtNodeConsistentId(Object dhtNodeConsistentId) {
        this.dhtNodeConsistentId = dhtNodeConsistentId;
    }

    public Map<Integer, String> usedCaches() {
        return this.usedCaches;
    }

    public void usedCaches(Map<Integer, String> usedCaches) {
        this.usedCaches = usedCaches;
    }

    public Map<Integer, String> usedCacheGroups() {
        return this.usedCacheGroups;
    }

    public void usedCacheGroups(Map<Integer, String> usedCacheGroups) {
        this.usedCacheGroups = usedCacheGroups;
    }

    public List<TxVerboseKey> localTxKeys() {
        return this.locTxKeys;
    }

    public void localTxKeys(List<TxVerboseKey> locTxKeys) {
        this.locTxKeys = locTxKeys;
    }

    public List<TxVerboseKey> nearOnlyTxKeys() {
        return this.nearOnlyTxKeys;
    }

    public void nearOnlyTxKeys(List<TxVerboseKey> nearOnlyTxKeys) {
        this.nearOnlyTxKeys = nearOnlyTxKeys;
    }

    public String toString() {
        return S.toString(TxVerboseInfo.class, this);
    }
}

