/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientObjectResponse;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheKeyRequest;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientCacheInvokeRequest
extends ClientCacheKeyRequest {
    private final EntryProcessorReader entryProcReader;

    public ClientCacheInvokeRequest(BinaryReaderExImpl reader) {
        super(reader);
        this.entryProcReader = new EntryProcessorReader(reader);
    }

    @Override
    public ClientResponse process0(ClientConnectionContext ctx) {
        try {
            Object val = this.cache(ctx).invoke(this.key(), this.entryProcReader.getEntryProcessor(), this.entryProcReader.getArgs(this.isKeepBinary()));
            return new ClientObjectResponse(this.requestId(), val);
        }
        catch (EntryProcessorException e) {
            throw new IgniteClientException(1040, e.getMessage(), e);
        }
    }

    @Override
    protected IgniteInternalFuture<ClientResponse> processAsync0(ClientConnectionContext ctx) {
        return ClientCacheInvokeRequest.chainFuture(this.cache(ctx).invokeAsync(this.key(), this.entryProcReader.getEntryProcessor(), this.entryProcReader.getArgs(this.isKeepBinary())), v -> new ClientObjectResponse(this.requestId(), v)).chain(f -> {
            try {
                return (ClientResponse)f.get();
            }
            catch (Exception e) {
                Exception e0 = U.unwrap(e);
                if (X.hasCause((Throwable)e0, EntryProcessorException.class)) {
                    throw new IgniteClientException(1040, e0.getMessage(), e0);
                }
                throw new GridClosureException(e0);
            }
        });
    }

    public static class EntryProcessorReader {
        private final Object entryProc;
        private final byte entryProcPlatform;
        private final Object[] args;
        private final BinaryReaderExImpl reader;
        private final int argsStartPos;

        public EntryProcessorReader(BinaryReaderExImpl reader) {
            this.entryProc = reader.readObjectDetached();
            this.entryProcPlatform = reader.readByte();
            int argCnt = reader.readInt();
            this.reader = reader;
            this.argsStartPos = reader.in().position();
            this.args = new Object[argCnt];
            for (int i = 0; i < argCnt; ++i) {
                this.args[i] = reader.readObjectDetached();
            }
        }

        public EntryProcessor<Object, Object, Object> getEntryProcessor() {
            if (!(this.entryProc instanceof BinaryObject)) {
                throw new IgniteClientException(1, "Entry processor should be marshalled as a BinaryObject: " + this.entryProc.getClass());
            }
            BinaryObjectImpl bo = (BinaryObjectImpl)this.entryProc;
            if (this.entryProcPlatform == 1) {
                return (EntryProcessor)bo.deserialize();
            }
            throw new IgniteClientException(1, "Unsupported entry processor platform: " + this.entryProcPlatform);
        }

        public Object[] getArgs(boolean keepBinary) {
            this.reader.in().position(this.argsStartPos);
            if (!keepBinary && this.args.length > 0) {
                for (int i = 0; i < this.args.length; ++i) {
                    this.args[i] = this.reader.readObject();
                }
            }
            return this.args;
        }
    }
}

