/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import java.io.ObjectInputFilter;
import org.apache.ignite.marshaller.IgniteMarshallerClassFilter;

public class IgniteObjectInputFilter
implements ObjectInputFilter {
    private final IgniteMarshallerClassFilter clsFilter;

    public IgniteObjectInputFilter(IgniteMarshallerClassFilter clsFilter) {
        this.clsFilter = clsFilter;
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        Class<?> cls = filterInfo.serialClass();
        if (cls == null) {
            return ObjectInputFilter.Status.UNDECIDED;
        }
        return this.clsFilter.apply(cls.getName()) ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
    }

    public IgniteMarshallerClassFilter classFilter() {
        return this.clsFilter;
    }
}

