/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import org.apache.ignite.internal.metastorage.client.Condition;
import org.apache.ignite.internal.metastorage.common.ConditionType;

public final class SimpleCondition
implements Condition {
    private final InnerCondition cond;

    SimpleCondition(InnerCondition cond) {
        this.cond = cond;
    }

    public InnerCondition inner() {
        return this.cond;
    }

    public ConditionType type() {
        return this.cond.type();
    }

    private static void validate(Enum<?> type) {
        if (type != null) {
            throw new IllegalStateException("Condition type " + type.name() + " is already defined.");
        }
    }

    private static abstract class AbstractCondition
    implements InnerCondition {
        private final byte[] key;
        private ConditionType type;

        private AbstractCondition(byte[] key) {
            this.key = key;
        }

        @Override
        public byte[] key() {
            return this.key;
        }

        @Override
        public ConditionType type() {
            return this.type;
        }

        protected void type(ConditionType type) {
            this.type = type;
        }
    }

    public static interface InnerCondition {
        public byte[] key();

        public ConditionType type();
    }

    public static final class TombstoneCondition
    extends AbstractCondition {
        TombstoneCondition(byte[] key) {
            super(key);
        }

        public SimpleCondition tombstone() {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.TOMBSTONE);
            return new SimpleCondition(this);
        }
    }

    public static final class ExistenceCondition
    extends AbstractCondition {
        ExistenceCondition(byte[] key) {
            super(key);
        }

        public SimpleCondition exists() {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.KEY_EXISTS);
            return new SimpleCondition(this);
        }

        public SimpleCondition notExists() {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.KEY_NOT_EXISTS);
            return new SimpleCondition(this);
        }
    }

    public static final class ValueCondition
    extends AbstractCondition {
        private byte[] val;

        ValueCondition(byte[] key) {
            super(key);
        }

        public byte[] value() {
            return this.val;
        }

        public SimpleCondition eq(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_EQUAL);
            this.val = val;
            return new SimpleCondition(this);
        }

        public SimpleCondition ne(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_NOT_EQUAL);
            this.val = val;
            return new SimpleCondition(this);
        }

        public SimpleCondition gt(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_GREATER);
            this.val = val;
            return new SimpleCondition(this);
        }

        public SimpleCondition ge(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_GREATER_OR_EQUAL);
            this.val = val;
            return new SimpleCondition(this);
        }

        public SimpleCondition lt(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_LESS);
            this.val = val;
            return new SimpleCondition(this);
        }

        public SimpleCondition le(byte[] val) {
            SimpleCondition.validate(this.type());
            this.type(ConditionType.VAL_LESS_OR_EQUAL);
            this.val = val;
            return new SimpleCondition(this);
        }
    }

    public static final class RevisionCondition
    extends AbstractCondition {
        private long rev;

        RevisionCondition(byte[] key) {
            super(key);
        }

        public long revision() {
            return this.rev;
        }

        public SimpleCondition eq(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_EQUAL);
            this.rev = rev;
            return new SimpleCondition(this);
        }

        public SimpleCondition ne(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_NOT_EQUAL);
            this.rev = rev;
            return new SimpleCondition(this);
        }

        public SimpleCondition gt(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_GREATER);
            this.rev = rev;
            return new SimpleCondition(this);
        }

        public SimpleCondition ge(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_GREATER_OR_EQUAL);
            this.rev = rev;
            return new SimpleCondition(this);
        }

        public SimpleCondition lt(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_LESS);
            this.rev = rev;
            return new SimpleCondition(this);
        }

        public SimpleCondition le(long rev) {
            assert (rev > 0L) : "Revision must be positive.";
            SimpleCondition.validate(this.type());
            this.type(ConditionType.REV_LESS_OR_EQUAL);
            this.rev = rev;
            return new SimpleCondition(this);
        }
    }
}

