/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.netty.DefaultHttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpPipelineBuilder;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.NettyEmbeddedServerInstance;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.util.DefaultHttpHostResolver;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.web.router.Router;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class NettyHttpServer
implements NettyEmbeddedServer {
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final NettyEmbeddedServices nettyEmbeddedServices;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final Environment environment;
    private final RoutingInBoundHandler routingHandler;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final boolean isDefault;
    private final ApplicationContext applicationContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final HttpHostResolver hostResolver;
    private boolean shutdownWorker = false;
    private boolean shutdownParent = false;
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private EmbeddedServerInstance serviceInstance;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);
    @Nullable
    private volatile List<Listener> activeListeners = null;
    private final List<NettyHttpServerConfiguration.NettyListenerConfiguration> listenerConfigurations;

    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices nettyEmbeddedServices, NettyCustomizableResponseTypeHandlerRegistry handlerRegistry, boolean isDefault) {
        this.isDefault = isDefault;
        this.serverConfiguration = serverConfiguration;
        this.nettyEmbeddedServices = nettyEmbeddedServices;
        Optional location = this.serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = nettyEmbeddedServices.getApplicationContext();
        this.environment = this.applicationContext.getEnvironment();
        ServerSslBuilder serverSslBuilder = nettyEmbeddedServices.getServerSslBuilder();
        this.sslConfiguration = serverSslBuilder != null ? serverSslBuilder.getSslConfiguration() : null;
        ApplicationEventPublisher<HttpRequestTerminatedEvent> httpRequestTerminatedEventPublisher = nettyEmbeddedServices.getEventPublisher(HttpRequestTerminatedEvent.class);
        Supplier ioExecutor = SupplierUtil.memoized(() -> nettyEmbeddedServices.getExecutorSelector().select("io").orElse(null));
        this.httpContentProcessorResolver = new DefaultHttpContentProcessorResolver((BeanLocator)nettyEmbeddedServices.getApplicationContext(), (BeanProvider<NettyHttpServerConfiguration>)((BeanProvider)() -> serverConfiguration));
        this.routingHandler = new RoutingInBoundHandler(serverConfiguration, handlerRegistry, nettyEmbeddedServices, ioExecutor, this.httpContentProcessorResolver, httpRequestTerminatedEventPublisher);
        this.hostResolver = new DefaultHttpHostResolver((HttpServerConfiguration)serverConfiguration, () -> this);
        this.listenerConfigurations = this.buildListenerConfigurations();
    }

    private List<NettyHttpServerConfiguration.NettyListenerConfiguration> buildListenerConfigurations() {
        List<NettyHttpServerConfiguration.NettyListenerConfiguration> explicit = this.serverConfiguration.getListeners();
        if (explicit != null) {
            if (explicit.isEmpty()) {
                throw new IllegalArgumentException("When configuring listeners explicitly, must specify at least one");
            }
            return explicit;
        }
        String configuredHost = this.serverConfiguration.getHost().orElse(null);
        ArrayList<NettyHttpServerConfiguration.NettyListenerConfiguration> implicit = new ArrayList<NettyHttpServerConfiguration.NettyListenerConfiguration>(2);
        ServerSslBuilder serverSslBuilder = this.nettyEmbeddedServices.getServerSslBuilder();
        if (serverSslBuilder != null && this.sslConfiguration.isEnabled()) {
            implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.sslConfiguration.getPort(), true));
        } else {
            implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.getHttpPort(this.serverConfiguration), false));
        }
        if (this.isDefault) {
            if (this.serverConfiguration.isDualProtocol()) {
                implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.getHttpPort(this.serverConfiguration), false));
            }
            Router router = this.nettyEmbeddedServices.getRouter();
            Set exposedPorts = router.getExposedPorts();
            Iterator iterator = exposedPorts.iterator();
            while (iterator.hasNext()) {
                int exposedPort = (Integer)iterator.next();
                if (exposedPort != -1 && exposedPort != 0 && !implicit.stream().noneMatch(cfg -> cfg.getPort() == exposedPort)) continue;
                NettyHttpServerConfiguration.NettyListenerConfiguration mgmt = NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, exposedPort, false);
                mgmt.setExposeDefaultRoutes(false);
                implicit.add(mgmt);
            }
        }
        return implicit;
    }

    private int getHttpPort(NettyHttpServerConfiguration serverConfiguration) {
        Integer configPort = serverConfiguration.getPort().orElse(null);
        return this.getHttpPort(configPort);
    }

    private int getHttpPort(Integer configPort) {
        if (configPort != null) {
            return configPort;
        }
        if (this.environment.getActiveNames().contains("test")) {
            return -1;
        }
        return 8080;
    }

    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public synchronized NettyEmbeddedServer start() {
        if (!this.isRunning()) {
            Router router;
            Set exposedPorts;
            EventLoopGroupConfiguration workerConfig = this.resolveWorkerConfiguration();
            this.workerGroup = this.createWorkerEventLoopGroup(workerConfig);
            this.parentGroup = this.createParentEventLoopGroup();
            ServerBootstrap serverBootstrap = this.createServerBootstrap();
            this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).option(arg_0, arg_1));
            this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).childOption(arg_0, arg_1));
            serverBootstrap = serverBootstrap.group(this.parentGroup, this.workerGroup);
            ArrayList<Listener> listeners = new ArrayList<Listener>();
            for (NettyHttpServerConfiguration.NettyListenerConfiguration listenerConfiguration : this.listenerConfigurations) {
                Listener listener = this.bind(serverBootstrap, listenerConfiguration, workerConfig);
                listeners.add(listener);
            }
            this.activeListeners = Collections.unmodifiableList(listeners);
            if (this.isDefault && CollectionUtils.isNotEmpty((Collection)(exposedPorts = (router = this.nettyEmbeddedServices.getRouter()).getExposedPorts()))) {
                router.applyDefaultPorts(listeners.stream().filter(l -> l.config.isExposeDefaultRoutes()).map(l -> l.serverChannel.localAddress()).filter(InetSocketAddress.class::isInstance).map(addr -> ((InetSocketAddress)addr).getPort()).collect(Collectors.toList()));
            }
            this.fireStartupEvents();
            this.running.set(true);
        }
        return this;
    }

    private EventLoopGroupConfiguration resolveWorkerConfiguration() {
        NettyHttpServerConfiguration.Worker workerConfig = this.serverConfiguration.getWorker();
        if (workerConfig == null) {
            workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration("default").orElse(null);
        } else {
            String eventLoopGroupName = workerConfig.getName();
            if (!"default".equals(eventLoopGroupName)) {
                workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration(eventLoopGroupName).orElse(workerConfig);
            }
        }
        return workerConfig;
    }

    @Override
    public synchronized NettyEmbeddedServer stop() {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal();
        }
        return this;
    }

    public int getPort() {
        List<Listener> listenersLocal = this.activeListeners;
        boolean hasRandom = false;
        boolean hasUnix = false;
        if (listenersLocal == null) {
            for (NettyHttpServerConfiguration.NettyListenerConfiguration listenerCfg : this.listenerConfigurations) {
                switch (listenerCfg.getFamily()) {
                    case TCP: {
                        if (listenerCfg.getPort() == -1) {
                            hasRandom = true;
                            break;
                        }
                        return listenerCfg.getPort();
                    }
                    case UNIX: {
                        hasUnix = true;
                        break;
                    }
                }
            }
        } else {
            for (Listener listener : listenersLocal) {
                SocketAddress localAddress = listener.serverChannel.localAddress();
                if (localAddress instanceof InetSocketAddress) {
                    return ((InetSocketAddress)localAddress).getPort();
                }
                hasUnix = true;
            }
        }
        if (hasRandom) {
            throw new UnsupportedOperationException("Retrieving the port from the server before it has started is not supported when binding to a random port");
        }
        if (hasUnix) {
            throw new UnsupportedOperationException("Retrieving the port from the server is not supported for unix domain sockets");
        }
        throw new UnsupportedOperationException("Could not retrieve server port");
    }

    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(CachedEnvironment.getenv((String)"HOSTNAME")).orElse("localhost"));
    }

    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    @Override
    public final Set<Integer> getBoundPorts() {
        List<Listener> listeners = this.activeListeners;
        if (listeners == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(listeners.stream().map(l -> l.serverChannel.localAddress()).filter(InetSocketAddress.class::isInstance).map(addr -> ((InetSocketAddress)addr).getPort()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(parent != null ? parent.getName() : "parent").orElseGet(() -> {
            EventLoopGroup newGroup = this.newEventLoopGroup(parent);
            this.shutdownParent = true;
            return newGroup;
        });
    }

    protected EventLoopGroup createWorkerEventLoopGroup(@Nullable EventLoopGroupConfiguration workerConfig) {
        String configName = workerConfig != null ? workerConfig.getName() : "default";
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(configName).orElseGet(() -> {
            LOG.warn("The configuration for 'micronaut.server.netty.worker.{}' is deprecated. Use 'micronaut.netty.event-loops.default' configuration instead.", (Object)configName);
            EventLoopGroup newGroup = this.newEventLoopGroup(workerConfig);
            this.shutdownWorker = true;
            return newGroup;
        });
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private Listener bind(ServerBootstrap bootstrap, NettyHttpServerConfiguration.NettyListenerConfiguration cfg, EventLoopGroupConfiguration workerConfig) {
        this.logBind(cfg);
        try {
            ChannelFuture future;
            Listener listener = new Listener(cfg);
            ServerBootstrap listenerBootstrap = bootstrap.clone();
            listenerBootstrap.childHandler((ChannelHandler)listener);
            switch (cfg.getFamily()) {
                case TCP: {
                    listenerBootstrap.channelFactory(() -> this.nettyEmbeddedServices.getServerSocketChannelInstance(workerConfig));
                    int port = cfg.getPort();
                    if (port == -1) {
                        port = 0;
                    }
                    if (cfg.getHost() == null) {
                        future = listenerBootstrap.bind(port);
                        break;
                    }
                    future = listenerBootstrap.bind(cfg.getHost(), port);
                    break;
                }
                case UNIX: {
                    listenerBootstrap.channelFactory(() -> this.nettyEmbeddedServices.getDomainServerChannelInstance(workerConfig));
                    future = listenerBootstrap.bind(DomainSocketHolder.makeDomainSocketAddress(cfg.getPath()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported family: " + (Object)((Object)cfg.getFamily()));
                }
            }
            listener.serverChannel = future.channel();
            future.syncUninterruptibly();
            return listener;
        }
        catch (Exception e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port {} already in use.", (Object)NettyHttpServer.displayAddress(cfg));
                } else {
                    LOG.error("Error starting Micronaut server: " + e.getMessage(), (Throwable)e);
                }
            }
            this.stopInternal();
            throw new ServerStartupException("Unable to start Micronaut server on " + NettyHttpServer.displayAddress(cfg), (Throwable)e);
        }
    }

    private void logBind(NettyHttpServerConfiguration.NettyListenerConfiguration cfg) {
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding {} server to {}", applicationName.get(), (Object)NettyHttpServer.displayAddress(cfg));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Binding server to {}", (Object)NettyHttpServer.displayAddress(cfg));
        }
    }

    private static String displayAddress(NettyHttpServerConfiguration.NettyListenerConfiguration cfg) {
        switch (cfg.getFamily()) {
            case TCP: {
                if (cfg.getHost() == null) {
                    return "*:" + cfg.getPort();
                }
                return cfg.getHost() + ":" + cfg.getPort();
            }
            case UNIX: {
                if (cfg.getPath().startsWith("\u0000")) {
                    return "unix:@" + cfg.getPath().substring(1);
                }
                return "unix:" + cfg.getPath();
            }
        }
        throw new UnsupportedOperationException("Unsupported family: " + (Object)((Object)cfg.getFamily()));
    }

    private void fireStartupEvents() {
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        this.applicationContext.getEventPublisher(ServerStartupEvent.class).publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
        applicationName.ifPresent(id -> {
            if (this.serviceInstance == null) {
                this.serviceInstance = (EmbeddedServerInstance)this.applicationContext.createBean(NettyEmbeddedServerInstance.class, new Object[]{id, this});
            }
            this.applicationContext.getEventPublisher(ServiceReadyEvent.class).publishEvent((Object)new ServiceReadyEvent((ServiceInstance)this.serviceInstance));
        });
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: " + e.getMessage(), e);
        }
    }

    private void stopInternal() {
        block8: {
            try {
                if (this.shutdownParent) {
                    NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
                    if (parent != null) {
                        long quietPeriod = parent.getShutdownQuietPeriod().toMillis();
                        long timeout = parent.getShutdownTimeout().toMillis();
                        this.parentGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS).addListener(this::logShutdownErrorIfNecessary);
                    } else {
                        this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                    }
                }
                if (this.shutdownWorker) {
                    this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                }
                this.webSocketSessions.close();
                this.applicationContext.getEventPublisher(ServerShutdownEvent.class).publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.serviceInstance != null) {
                    this.applicationContext.getEventPublisher(ServiceStoppedEvent.class).publishEvent((Object)new ServiceStoppedEvent((ServiceInstance)this.serviceInstance));
                }
                if (this.isDefault && this.applicationContext.isRunning()) {
                    this.applicationContext.stop();
                }
                this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                    DiskFileUpload.baseDirectory = null;
                });
                this.activeListeners = null;
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error("Error stopping Micronaut server: " + e.getMessage(), e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(EventLoopGroupConfiguration config) {
        if (config != null) {
            ExecutorService executorService = config.getExecutorName().flatMap(name -> this.applicationContext.findBean(ExecutorService.class, Qualifiers.byName((String)name))).orElse(null);
            if (executorService != null) {
                return this.nettyEmbeddedServices.createEventLoopGroup(config.getNumThreads(), executorService, config.getIoRatio().orElse(null));
            }
            return this.nettyEmbeddedServices.createEventLoopGroup(config);
        }
        return this.nettyEmbeddedServices.createEventLoopGroup((EventLoopGroupConfiguration)new DefaultEventLoopGroupConfiguration());
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        ChannelOptionFactory channelOptionFactory = this.nettyEmbeddedServices.getChannelOptionFactory();
        options.forEach((option, value) -> biConsumer.accept((ChannelOption)option, channelOptionFactory.convertValue(option, value, this.environment)));
    }

    public void addChannel(Channel channel) {
        this.webSocketSessions.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove((Object)channel);
    }

    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }

    private HttpToHttp2ConnectionHandler newHttpToHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        StreamingInboundHttp2ToHttpAdapter http2ToHttpAdapter = new StreamingInboundHttp2ToHttpAdapter((Http2Connection)connection, (int)this.serverConfiguration.getMaxRequestSize(), this.serverConfiguration.isValidateHeaders(), true);
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)http2ToHttpAdapter).validateHeaders(this.serverConfiguration.isValidateHeaders()).initialSettings(this.serverConfiguration.getHttp2().http2Settings());
        this.serverConfiguration.getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
        return builder.connection((Http2Connection)connection).build();
    }

    public boolean isClientChannel() {
        return false;
    }

    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    public Set<String> getObservedConfigurationPrefixes() {
        return Collections.singleton("micronaut.server");
    }

    public void onApplicationEvent(RefreshEvent event) {
        List<Listener> listeners = this.activeListeners;
        if (listeners != null) {
            for (Listener listener : listeners) {
                listener.refresh();
            }
        }
    }

    final void triggerPipelineListeners(ChannelPipeline pipeline) {
        for (ChannelPipelineListener pipelineListener : this.pipelineListeners) {
            pipelineListener.onConnect(pipeline);
        }
    }

    private HttpPipelineBuilder createPipelineBuilder() {
        return new HttpPipelineBuilder(this, this.nettyEmbeddedServices, this.sslConfiguration, this.routingHandler, this.hostResolver);
    }

    @Internal
    public EmbeddedChannel buildEmbeddedChannel(boolean ssl) {
        EmbeddedChannel embeddedChannel = new EmbeddedChannel();
        HttpPipelineBuilder httpPipelineBuilder = this.createPipelineBuilder();
        Objects.requireNonNull(httpPipelineBuilder);
        httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline((Channel)embeddedChannel, ssl).initChannel();
        return embeddedChannel;
    }

    static Predicate<String> inclusionPredicate(NettyHttpServerConfiguration.AccessLogger config) {
        List<String> exclusions = config.getExclusions();
        if (CollectionUtils.isEmpty(exclusions)) {
            return null;
        }
        List patterns = exclusions.stream().map(Pattern::compile).collect(Collectors.toList());
        return uri -> patterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)uri).matches());
    }

    private static class DomainSocketHolder {
        private DomainSocketHolder() {
        }

        @NonNull
        private static SocketAddress makeDomainSocketAddress(String path) {
            try {
                return new DomainSocketAddress(path);
            }
            catch (NoClassDefFoundError e) {
                throw new UnsupportedOperationException("Netty domain socket support not on classpath", e);
            }
        }
    }

    private class Listener
    extends ChannelInitializer<Channel> {
        Channel serverChannel;
        NettyHttpServerConfiguration.NettyListenerConfiguration config;
        private volatile HttpPipelineBuilder httpPipelineBuilder;

        Listener(NettyHttpServerConfiguration.NettyListenerConfiguration config) {
            this.config = config;
            this.refresh();
        }

        void refresh() {
            this.httpPipelineBuilder = NettyHttpServer.this.createPipelineBuilder();
            if (this.config.isSsl() && !this.httpPipelineBuilder.supportsSsl()) {
                throw new IllegalStateException("Listener configured for SSL, but no SSL context available");
            }
        }

        protected void initChannel(@NonNull Channel ch) throws Exception {
            HttpPipelineBuilder httpPipelineBuilder = this.httpPipelineBuilder;
            Objects.requireNonNull(httpPipelineBuilder);
            httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline(ch, this.config.isSsl()).initChannel();
        }
    }
}

