/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.RangeBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class RexUtils {
    public static final int MAX_SEARCH_BOUNDS_COMPLEXITY = 100;
    private static final Set<SqlKind> BINARY_COMPARISON = EnumSet.of(SqlKind.EQUALS, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL);
    private static final Set<SqlKind> TREE_INDEX_COMPARISON = EnumSet.of(SqlKind.SEARCH, new SqlKind[]{SqlKind.IS_NULL, SqlKind.IS_NOT_NULL, SqlKind.EQUALS, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL});

    public static RexNode makeCast(RexBuilder builder, RexNode node, RelDataType type) {
        return TypeUtils.needCast(builder.getTypeFactory(), node.getType(), type) ? builder.makeCast(type, node) : node;
    }

    public static RexBuilder builder(RelNode rel) {
        return RexUtils.builder(rel.getCluster());
    }

    public static RexBuilder builder(RelOptCluster cluster) {
        return cluster.getRexBuilder();
    }

    public static RexExecutor executor(RelNode rel) {
        return RexUtils.executor(rel.getCluster());
    }

    public static RexExecutor executor(RelOptCluster cluster) {
        return (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
    }

    public static RexSimplify simplifier(RelOptCluster cluster) {
        return new RexSimplify(RexUtils.builder(cluster), RelOptPredicateList.EMPTY, RexUtils.executor(cluster));
    }

    public static RexNode makeCase(RexBuilder builder, RexNode ... operands) {
        if (IgniteUtils.assertionsEnabled()) {
            for (int i = 0; i < operands.length; i += 2) {
                if (operands[i].getType().getSqlTypeName() != SqlTypeName.BOOLEAN && i < operands.length - 1) {
                    throw new AssertionError((Object)("Unexpected operand type. [operands=" + Arrays.toString(operands) + "]"));
                }
            }
        }
        return builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, operands);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType) {
        return RexUtils.isIdentity(projects, inputRowType, false);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType, boolean local) {
        if (inputRowType.getFieldCount() != projects.size()) {
            return false;
        }
        List fields = inputRowType.getFieldList();
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (int i = 0; i < fields.size(); ++i) {
            if (!clazz.isInstance(projects.get(i))) {
                return false;
            }
            RexSlot ref = (RexSlot)projects.get(i);
            if (ref.getIndex() != i) {
                return false;
            }
            if (RelOptUtil.eq((String)"t1", (RelDataType)projects.get(i).getType(), (String)"t2", (RelDataType)((RelDataTypeField)fields.get(i)).getType(), (Litmus)Litmus.IGNORE)) continue;
            return false;
        }
        return true;
    }

    public static List<SearchBounds> buildSortedIndexConditions(RelOptCluster cluster, RelCollation collation, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns) {
        RelFieldCollation fc;
        int collFldIdx;
        List collFldPreds;
        if (condition == null) {
            return null;
        }
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Int2ObjectMap<List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (CollectionUtils.nullOrEmpty(fieldsToPredicates)) {
            return null;
        }
        if (collation == null || collation.isDefault()) {
            IntArrayList fields = new IntArrayList(fieldsToPredicates.size());
            IntArrayList lastFields = new IntArrayList(fieldsToPredicates.size());
            fieldsToPredicates.int2ObjectEntrySet().forEach(entry -> (((List)entry.getValue()).stream().anyMatch(v -> v.getOperator().getKind() == SqlKind.EQUALS) ? fields : lastFields).add(entry.getIntKey()));
            fields.addAll((IntList)lastFields);
            collation = TraitUtils.createCollation((Collection<Integer>)fields);
        }
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        Mappings.TargetMapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.inverseMapping(requiredColumns, types.size());
        }
        List<SearchBounds> bounds = Arrays.asList(new SearchBounds[types.size()]);
        boolean boundsEmpty = true;
        int prevComplexity = 1;
        Iterator iterator = collation.getFieldCollations().iterator();
        while (iterator.hasNext() && !CollectionUtils.nullOrEmpty((Collection)(collFldPreds = (List)fieldsToPredicates.get(collFldIdx = (fc = (RelFieldCollation)iterator.next()).getFieldIndex())))) {
            SearchBounds fldBounds;
            if (mapping != null) {
                collFldIdx = mapping.getSourceOpt(collFldIdx);
            }
            if ((fldBounds = RexUtils.createBounds(fc, collFldPreds, cluster, (RelDataType)types.get(collFldIdx), prevComplexity)) == null) break;
            boundsEmpty = false;
            bounds.set(collFldIdx, fldBounds);
            if (fldBounds instanceof MultiBounds) {
                prevComplexity *= ((MultiBounds)fldBounds).bounds().size();
                if (((MultiBounds)fldBounds).bounds().stream().anyMatch(b -> b.type() != SearchBounds.Type.EXACT)) break;
            }
            if (fldBounds.type() != SearchBounds.Type.RANGE) continue;
            break;
        }
        return boundsEmpty ? null : bounds;
    }

    public static List<SearchBounds> buildHashIndexConditions(RelOptCluster cluster, List<String> indexedColumns, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns) {
        if (condition == null) {
            return null;
        }
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Int2ObjectMap<List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (CollectionUtils.nullOrEmpty(fieldsToPredicates)) {
            return null;
        }
        List<SearchBounds> bounds = Arrays.asList(new SearchBounds[rowType.getFieldCount()]);
        Mappings.TargetMapping toTrimmedRowMapping = null;
        if (requiredColumns != null) {
            toTrimmedRowMapping = Commons.mapping(requiredColumns, rowType.getFieldCount());
        }
        for (String columnName : indexedColumns) {
            RelDataTypeField field = rowType.getField(columnName, true, false);
            if (field == null) {
                return null;
            }
            int collFldIdx = toTrimmedRowMapping == null ? field.getIndex() : toTrimmedRowMapping.getTargetOpt(field.getIndex());
            List collFldPreds = (List)fieldsToPredicates.get(collFldIdx);
            if (CollectionUtils.nullOrEmpty((Collection)collFldPreds)) {
                return null;
            }
            RexCall columnPred = collFldPreds.stream().filter(pred -> pred.getOperator().getKind() == SqlKind.EQUALS).findAny().orElse(null);
            if (columnPred == null) {
                return null;
            }
            bounds.set(collFldIdx, RexUtils.createBounds(null, Collections.singletonList(columnPred), cluster, field.getType(), 1));
        }
        return bounds;
    }

    public static List<RexNode> buildHashSearchRow(RelOptCluster cluster, RexNode condition, RelDataType rowType) {
        List collFldPreds;
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Int2ObjectMap<List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (CollectionUtils.nullOrEmpty(fieldsToPredicates)) {
            return null;
        }
        ArrayList<RexCall> searchPreds = null;
        ObjectIterator objectIterator = fieldsToPredicates.values().iterator();
        while (objectIterator.hasNext() && !CollectionUtils.nullOrEmpty((Collection)(collFldPreds = (List)objectIterator.next()))) {
            for (RexCall pred : collFldPreds) {
                if (pred.getOperator().kind != SqlKind.EQUALS) {
                    return null;
                }
                if (searchPreds == null) {
                    searchPreds = new ArrayList<RexCall>();
                }
                searchPreds.add(pred);
            }
        }
        if (searchPreds == null) {
            return null;
        }
        return RexUtils.asBound(cluster, searchPreds, rowType, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static SearchBounds createBounds(@Nullable RelFieldCollation fc, List<RexCall> collFldPreds, RelOptCluster cluster, RelDataType fldType, int prevComplexity) {
        builder = RexUtils.builder(cluster);
        nullVal = builder.makeNullLiteral(fldType);
        upperCond = null;
        lowerCond = null;
        upperBound = null;
        lowerBound = null;
        upperInclude = true;
        lowerInclude = true;
        block5: for (RexCall pred : collFldPreds) {
            val = null;
            if (RexUtils.isBinaryComparison((RexNode)pred)) {
                val = RexUtil.removeCast((RexNode)((RexNode)pred.operands.get(1)));
                if (!RexUtils.$assertionsDisabled && !RexUtils.idxOpSupports(val)) {
                    throw new AssertionError(val);
                }
                val = RexUtils.makeCast(builder, val, fldType);
            }
            op = pred.getOperator();
            if (op.kind == SqlKind.EQUALS) {
                return new ExactBounds((RexNode)pred, val);
            }
            if (op.kind == SqlKind.IS_NULL) {
                return new ExactBounds((RexNode)pred, (RexNode)nullVal);
            }
            if (op.kind == SqlKind.SEARCH) {
                sarg = (Sarg)((RexLiteral)pred.operands.get(1)).getValueAs(Sarg.class);
                complexity = prevComplexity * sarg.complexity();
                if (complexity > 100) {
                    return null;
                }
                sargCond = RexUtil.sargRef((RexBuilder)builder, (RexNode)((RexNode)pred.operands.get(0)), (Sarg)sarg, (RelDataType)fldType, (RexUnknownAs)RexUnknownAs.UNKNOWN);
                disjunctions = RelOptUtil.disjunctions((RexNode)RexUtil.toDnf((RexBuilder)builder, (RexNode)sargCond));
                bounds = new ArrayList<SearchBounds>(disjunctions.size());
                for (RexNode bound : disjunctions) {
                    conjunctions = RelOptUtil.conjunctions((RexNode)bound);
                    calls = new ArrayList<RexCall>(conjunctions.size());
                    for (RexNode rexNode : conjunctions) {
                        if (RexUtils.isSupportedTreeComparison(rexNode)) {
                            calls.add((RexCall)rexNode);
                            continue;
                        }
                        return null;
                    }
                    bounds.add(RexUtils.createBounds(fc, calls, cluster, fldType, complexity));
                }
                if (bounds.size() == 1) {
                    return (SearchBounds)bounds.get(0);
                }
                return new MultiBounds((RexNode)pred, bounds);
            }
            lowerBoundBelow = fc.getDirection().isDescending() == false;
            switch (3.$SwitchMap$org$apache$calcite$sql$SqlKind[op.kind.ordinal()]) {
                case 1: 
                case 2: {
                    lowerBoundBelow = lowerBoundBelow == false;
                }
                case 3: 
                case 4: {
                    if (!lowerBoundBelow) ** GOTO lbl55
                    lowerCond = pred;
                    lowerBound = val;
                    if (op.kind == SqlKind.GREATER_THAN || op.kind == SqlKind.LESS_THAN) {
                        lowerInclude = false;
                    }
                    ** GOTO lbl59
lbl55:
                    // 1 sources

                    upperCond = pred;
                    upperBound = val;
                    if (op.kind == SqlKind.GREATER_THAN || op.kind == SqlKind.LESS_THAN) {
                        upperInclude = false;
                    }
                }
lbl59:
                // 5 sources

                case 5: {
                    if (fc.nullDirection == RelFieldCollation.NullDirection.FIRST && lowerBound == null) {
                        lowerCond = pred;
                        lowerBound = nullVal;
                        lowerInclude = false;
                        continue block5;
                    }
                    if (fc.nullDirection != RelFieldCollation.NullDirection.LAST || upperBound != null) continue block5;
                    upperCond = pred;
                    upperBound = nullVal;
                    upperInclude = false;
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unknown condition: " + op.kind));
        }
        if (lowerBound == null && upperBound == null) {
            return null;
        }
        cond = lowerCond == null ? upperCond : (upperCond == null ? lowerCond : (upperCond == lowerCond ? lowerCond : builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{lowerCond, upperCond})));
        return new RangeBounds(cond, lowerBound, upperBound, lowerInclude, upperInclude);
    }

    private static Int2ObjectMap<List<RexCall>> mapPredicatesToFields(RexNode condition, RelOptCluster cluster) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)condition);
        if (conjunctions.isEmpty()) {
            return Int2ObjectMaps.emptyMap();
        }
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap(conjunctions.size());
        for (RexNode rexNode : conjunctions) {
            RexSlot ref;
            if (!RexUtils.isSupportedTreeComparison(rexNode)) continue;
            RexCall predCall = (RexCall)rexNode;
            if (RexUtils.isBinaryComparison(rexNode)) {
                ref = (RexSlot)RexUtils.extractRefFromBinary(predCall, cluster);
                if (ref == null) continue;
                if (RexUtils.refOnTheRight(predCall)) {
                    predCall = (RexCall)RexUtil.invert((RexBuilder)RexUtils.builder(cluster), (RexCall)predCall);
                }
            } else {
                ref = (RexSlot)RexUtils.extractRefFromOperand(predCall, cluster, 0);
                if (ref == null) continue;
            }
            List fldPreds = (List)res.computeIfAbsent(ref.getIndex(), k -> new ArrayList(conjunctions.size()));
            fldPreds.add(predCall);
        }
        return res;
    }

    private static RexNode extractRefFromBinary(RexCall call, RelOptCluster cluster) {
        assert (RexUtils.isBinaryComparison((RexNode)call));
        RexNode leftRef = RexUtils.extractRefFromOperand(call, cluster, 0);
        RexNode rightOp = (RexNode)call.getOperands().get(1);
        if (leftRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)rightOp)) ? leftRef : null;
        }
        RexNode rightRef = RexUtils.extractRefFromOperand(call, cluster, 1);
        RexNode leftOp = (RexNode)call.getOperands().get(0);
        if (rightRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)leftOp)) ? rightRef : null;
        }
        return null;
    }

    private static RexNode extractRefFromOperand(RexCall call, RelOptCluster cluster, int operandNum) {
        assert (RexUtils.isSupportedTreeComparison((RexNode)call));
        RexNode op = (RexNode)call.getOperands().get(operandNum);
        if ((op = RexUtil.removeCast((RexNode)op)) instanceof RexSlot && !TypeUtils.needCast(cluster.getTypeFactory(), op.getType(), ((RexNode)call.getOperands().get(operandNum)).getType())) {
            return op;
        }
        return null;
    }

    private static boolean refOnTheRight(RexCall predCall) {
        RexNode rightOp = (RexNode)predCall.getOperands().get(1);
        return (rightOp = RexUtil.removeCast((RexNode)rightOp)).isA(SqlKind.LOCAL_REF) || rightOp.isA(SqlKind.INPUT_REF);
    }

    private static boolean isBinaryComparison(RexNode exp) {
        return BINARY_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall && ((RexCall)exp).getOperands().size() == 2;
    }

    private static boolean isSupportedTreeComparison(RexNode exp) {
        return TREE_INDEX_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall;
    }

    private static boolean idxOpSupports(RexNode op) {
        return op instanceof RexLiteral || op instanceof RexDynamicParam || op instanceof RexFieldAccess;
    }

    public static boolean isNotNull(RexNode op) {
        if (op == null) {
            return false;
        }
        return !(op instanceof RexLiteral) || !((RexLiteral)op).isNull();
    }

    @Deprecated(forRemoval=true)
    public static List<RexNode> asBound(RelOptCluster cluster, Iterable<RexNode> idxCond, RelDataType rowType, @Nullable Mappings.TargetMapping mapping) {
        if (CollectionUtils.nullOrEmpty(idxCond)) {
            return null;
        }
        RexBuilder builder = RexUtils.builder(cluster);
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        List<RexNode> res = Arrays.asList(new RexNode[types.size()]);
        for (RexNode pred : idxCond) {
            int index;
            assert (pred instanceof RexCall);
            RexCall call = (RexCall)pred;
            RexSlot ref = (RexSlot)RexUtil.removeCast((RexNode)((RexNode)call.operands.get(0)));
            RexNode cond = RexUtil.removeCast((RexNode)((RexNode)call.operands.get(1)));
            assert (RexUtils.idxOpSupports(cond)) : cond;
            int n = index = mapping == null ? ref.getIndex() : mapping.getSourceOpt(ref.getIndex());
            assert (index != -1);
            res.set(index, RexUtils.makeCast(builder, cond, (RelDataType)types.get(index)));
        }
        return res;
    }

    public static Mappings.TargetMapping inversePermutation(List<RexNode> nodes, RelDataType inputRowType, boolean local) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)nodes.size(), (int)inputRowType.getFieldCount());
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (Ord node : Ord.zip(nodes)) {
            if (!clazz.isInstance(node.e)) continue;
            mapping.set(node.i, ((RexSlot)node.e).getIndex());
        }
        return mapping;
    }

    public static List<RexNode> replaceInputRefs(List<RexNode> nodes) {
        return InputRefReplacer.INSTANCE.apply(nodes);
    }

    public static RexNode replaceInputRefs(RexNode node) {
        return InputRefReplacer.INSTANCE.apply(node);
    }

    public static RexNode replaceLocalRefs(RexNode node) {
        return LocalRefReplacer.INSTANCE.apply(node);
    }

    public static List<RexNode> replaceLocalRefs(List<RexNode> nodes) {
        return LocalRefReplacer.INSTANCE.apply(nodes);
    }

    public static boolean hasCorrelation(RexNode node) {
        return RexUtils.hasCorrelation(Collections.singletonList(node));
    }

    public static boolean hasCorrelation(List<RexNode> nodes) {
        try {
            RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

                public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                    throw new ControlFlowException();
                }
            };
            nodes.forEach(arg_0 -> RexUtils.lambda$hasCorrelation$5((RexVisitor)v, arg_0));
            return false;
        }
        catch (ControlFlowException e) {
            return true;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(RexNode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        return RexUtils.extractCorrelationIds(Collections.singletonList(node));
    }

    public static Set<CorrelationId> extractCorrelationIds(List<RexNode> nodes) {
        final HashSet<CorrelationId> cors = new HashSet<CorrelationId>();
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                cors.add(correlVariable.id);
                return null;
            }
        };
        nodes.forEach(arg_0 -> RexUtils.lambda$extractCorrelationIds$6((RexVisitor)v, arg_0));
        return cors;
    }

    public static IntSet notNullKeys(List<RexNode> row) {
        if (CollectionUtils.nullOrEmpty(row)) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet keys = new IntOpenHashSet();
        for (int i = 0; i < row.size(); ++i) {
            if (!RexUtils.isNotNull(row.get(i))) continue;
            keys.add(i);
        }
        return keys;
    }

    private static /* synthetic */ void lambda$extractCorrelationIds$6(RexVisitor v, RexNode rex) {
        rex.accept(v);
    }

    private static /* synthetic */ void lambda$hasCorrelation$5(RexVisitor v, RexNode n) {
        n.accept(v);
    }

    private static class InputRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new InputRefReplacer();

        private InputRefReplacer() {
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexLocalRef(inputRef.getIndex(), inputRef.getType());
        }
    }

    private static class LocalRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new LocalRefReplacer();

        private LocalRefReplacer() {
        }

        public RexNode visitLocalRef(RexLocalRef inputRef) {
            return new RexInputRef(inputRef.getIndex(), inputRef.getType());
        }
    }
}

