/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.storage.index.BinaryTupleComparator;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;

public class RocksDbBinaryTupleComparator
extends AbstractComparator {
    private final BinaryTupleComparator comparator;
    private final ComparatorOptions options;

    public RocksDbBinaryTupleComparator(SortedIndexDescriptor descriptor) {
        this(descriptor, new ComparatorOptions());
    }

    private RocksDbBinaryTupleComparator(SortedIndexDescriptor descriptor, ComparatorOptions options) {
        super(options);
        this.options = options;
        this.comparator = new BinaryTupleComparator(descriptor);
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public int compare(ByteBuffer a, ByteBuffer b) {
        int comparePartitionId = Short.compareUnsigned(a.getShort(), b.getShort());
        if (comparePartitionId != 0) {
            return comparePartitionId;
        }
        ByteBuffer firstBinaryTupleBuffer = a.slice().order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer secondBinaryTupleBuffer = b.slice().order(ByteOrder.LITTLE_ENDIAN);
        if (!firstBinaryTupleBuffer.hasRemaining()) {
            return -1;
        }
        if (!secondBinaryTupleBuffer.hasRemaining()) {
            return 1;
        }
        int compareTuples = this.comparator.compare(firstBinaryTupleBuffer, secondBinaryTupleBuffer);
        return compareTuples == 0 ? RocksDbBinaryTupleComparator.compareRowIds(a, b) : compareTuples;
    }

    private static int compareRowIds(ByteBuffer a, ByteBuffer b) {
        long secondMostSignBits;
        long firstMostSignBits = a.getLong(a.limit() - 16);
        int compare = Long.compare(firstMostSignBits, secondMostSignBits = b.getLong(b.limit() - 16));
        if (compare != 0) {
            return compare;
        }
        long firstLeastSignBits = a.getLong(a.limit() - 8);
        long secondLeastSignBits = b.getLong(b.limit() - 8);
        return Long.compare(firstLeastSignBits, secondLeastSignBits);
    }

    public void close() {
        super.close();
        this.options.close();
    }
}

