/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class DeltaFilePageStoreIoHeader {
    private static final long SIGNATURE = -2400507797356543629L;
    private static final int COMMON_HEADER_SIZE = 24;
    private final int version;
    private final int index;
    private final int pageSize;
    private final int[] pageIndexes;
    private final int headerSize;

    public DeltaFilePageStoreIoHeader(int version, int index, int pageSize, int[] pageIndexes) {
        assert (pageSize >= 24) : pageSize;
        assert (index >= 0) : index;
        this.version = version;
        this.index = index;
        this.pageSize = pageSize;
        this.pageIndexes = pageIndexes;
        int size = 24 + 4 * pageIndexes.length;
        if (size % pageSize != 0) {
            size = (size / pageSize + 1) * pageSize;
        }
        this.headerSize = size;
    }

    public int version() {
        return this.version;
    }

    public int index() {
        return this.index;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int headerSize() {
        return this.headerSize;
    }

    public int[] pageIndexes() {
        return this.pageIndexes;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.headerSize).order(ByteOrder.nativeOrder()).putLong(-2400507797356543629L).putInt(this.version).putInt(this.index).putInt(this.pageSize).putInt(this.pageIndexes.length);
        if (this.pageIndexes.length > 0) {
            buffer.asIntBuffer().put(this.pageIndexes);
        }
        return buffer;
    }

    @Nullable
    public static DeltaFilePageStoreIoHeader readHeader(FileIo fileIo, ByteBuffer headerBuffer) throws IOException {
        int len;
        assert (headerBuffer.remaining() >= 24) : headerBuffer.remaining();
        assert (headerBuffer.order() == ByteOrder.nativeOrder()) : headerBuffer.order();
        if (fileIo.size() < 24L) {
            return null;
        }
        fileIo.readFully(headerBuffer, 0L);
        long signature = headerBuffer.rewind().getLong();
        if (-2400507797356543629L != signature) {
            throw new IOException(String.format("Invalid file signature [expected=%s, actual=%s]", IgniteUtils.hexLong((long)-2400507797356543629L), IgniteUtils.hexLong((long)signature)));
        }
        int version = headerBuffer.getInt();
        int index = headerBuffer.getInt();
        int pageSize = headerBuffer.getInt();
        int arrayLen = headerBuffer.getInt();
        if (arrayLen == 0) {
            return new DeltaFilePageStoreIoHeader(version, index, pageSize, new int[0]);
        }
        assert (headerBuffer.remaining() % 4 == 0) : fileIo;
        int[] pageIndexes = new int[arrayLen];
        int filePosition = headerBuffer.capacity();
        for (int i = 0; i < arrayLen; i += len) {
            if (headerBuffer.remaining() == 0) {
                fileIo.readFully(headerBuffer.rewind(), (long)filePosition);
                filePosition += headerBuffer.rewind().capacity();
                assert (headerBuffer.remaining() % 4 == 0) : fileIo;
            }
            len = Math.min(headerBuffer.remaining() / 4, arrayLen - i);
            headerBuffer.asIntBuffer().get(pageIndexes, i, len);
            headerBuffer.position(headerBuffer.position() + len * 4);
        }
        return new DeltaFilePageStoreIoHeader(version, index, pageSize, pageIndexes);
    }

    public static void checkFileIndex(int expIndex, int actIndex) throws IOException {
        if (expIndex != actIndex) {
            throw new IOException(String.format("Invalid file indexes [expected=%s, actual=%s]", expIndex, actIndex));
        }
    }

    public static void checkFilePageIndexes(int[] expPageIndexes, int[] actPageIndexes) throws IOException {
        if (!Arrays.equals(expPageIndexes, actPageIndexes)) {
            throw new IOException(String.format("Invalid file pageIndexes [expected=%s, actual=%s]", Arrays.toString(expPageIndexes), Arrays.toString(actPageIndexes)));
        }
    }
}

