/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import org.apache.ignite.internal.cli.call.configuration.JsonString;
import org.apache.ignite.internal.cli.commands.treesitter.highlighter.HoconAnsiHighlighter;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;

public class HoconDecorator
implements Decorator<JsonString, TerminalOutput> {
    private final boolean highlight;

    public HoconDecorator(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public TerminalOutput decorate(JsonString json) {
        return () -> {
            try {
                Config config = ConfigFactory.parseString((String)json.getValue());
                String text = config.root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(false));
                if (text.endsWith("\n")) {
                    text = text.substring(0, text.length() - 1);
                }
                return this.highlight ? HoconAnsiHighlighter.highlight(text) : text;
            }
            catch (ConfigException.Parse e) {
                return json.getValue();
            }
        };
    }
}

