/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.exception;

import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class DeploymentUnitNotFoundException
extends IgniteException {
    private final String id;
    private final Version version;

    public DeploymentUnitNotFoundException(String id) {
        this(id, null);
    }

    public DeploymentUnitNotFoundException(String id, @Nullable Version version) {
        super(ErrorGroups.CodeDeployment.UNIT_NOT_FOUND_ERR, DeploymentUnitNotFoundException.message(id, version));
        this.id = id;
        this.version = version;
    }

    private static String message(String id, @Nullable Version version) {
        if (version == null) {
            return "Unit " + id + " not found";
        }
        return "Unit " + id + ":" + String.valueOf(version) + " not found";
    }

    public String id() {
        return this.id;
    }

    public Version version() {
        return this.version;
    }
}

