/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.cluster.management.NodeAttributes;
import org.apache.ignite.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite.internal.cluster.management.configuration.NodeAttributeView;
import org.apache.ignite.internal.cluster.management.configuration.NodeAttributesConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageProfileView;

public class NodeAttributesCollector
implements NodeAttributes {
    private final List<NodeAttributesProvider> systemAttributesProviders = new ArrayList<NodeAttributesProvider>();
    private final NodeAttributesConfiguration nodeAttributesConfiguration;
    private final StorageConfiguration storageProfilesConfiguration;

    public NodeAttributesCollector(NodeAttributesConfiguration nodeAttributesConfiguration, StorageConfiguration storageProfilesConfiguration) {
        this.nodeAttributesConfiguration = nodeAttributesConfiguration;
        this.storageProfilesConfiguration = storageProfilesConfiguration;
    }

    public void register(NodeAttributesProvider provider) {
        this.systemAttributesProviders.add(provider);
    }

    @Override
    public Map<String, String> userAttributes() {
        NamedListView attributes = (NamedListView)this.nodeAttributesConfiguration.nodeAttributes().value();
        return attributes.stream().collect(Collectors.toUnmodifiableMap(NodeAttributeView::name, NodeAttributeView::attribute));
    }

    @Override
    public List<String> storageProfiles() {
        NamedListView storageProfiles = (NamedListView)this.storageProfilesConfiguration.profiles().value();
        return storageProfiles.stream().map(StorageProfileView::name).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> systemAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (NodeAttributesProvider provider : this.systemAttributesProviders) {
            attributes.putAll(provider.nodeAttributes());
        }
        return attributes;
    }
}

