/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.internal.catalog.sql.SelectFromView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.QualifiedName;

class TableDefinitionCollector {
    private final QualifiedName tableName;
    private final IgniteSql sql;

    TableDefinitionCollector(QualifiedName tableName, IgniteSql sql) {
        this.tableName = tableName;
        this.sql = sql;
    }

    CompletableFuture<TableDefinition> collectDefinition() {
        return this.collectTableInfo().thenCompose(builder -> {
            if (builder == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.collectIndexes((TableDefinitionBuilderWithIndexId)builder).thenApply(TableDefinition.Builder::build);
        });
    }

    private CompletableFuture<TableDefinitionBuilderWithIndexId> collectTableInfo() {
        String query = "SELECT pk_index_id, zone_name, column_name, column_type, column_precision, column_scale, column_length, is_nullable_column, colocation_column_ordinal FROM system.tables t JOIN system.table_columns USING (table_id) WHERE t.schema_name=? AND t.table_name=? ORDER BY column_ordinal";
        return SelectFromView.collectResults(this.sql, query, Function.identity(), this.tableName.schemaName(), this.tableName.objectName()).thenApply(list -> {
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
            int indexId = ((SqlRow)list.get(0)).intValue("PK_INDEX_ID");
            String zoneName = ((SqlRow)list.get(0)).stringValue("ZONE_NAME");
            TreeMap<Integer, String> colocationColumns = new TreeMap<Integer, String>();
            for (SqlRow row : list) {
                String columnName = row.stringValue("COLUMN_NAME");
                String type = row.stringValue("COLUMN_TYPE");
                int length = row.intValue("COLUMN_LENGTH");
                int precision = row.intValue("COLUMN_PRECISION");
                int scale = row.intValue("COLUMN_SCALE");
                boolean nullable = row.booleanValue("IS_NULLABLE_COLUMN");
                Integer colocationOrd = (Integer)row.value("COLOCATION_COLUMN_ORDINAL");
                if (colocationOrd != null) {
                    colocationColumns.put(colocationOrd, columnName);
                }
                Class typeClass = ColumnType.valueOf((String)type).javaClass();
                org.apache.ignite.catalog.ColumnType columnType = org.apache.ignite.catalog.ColumnType.of((Class)typeClass, (Integer)length, (Integer)precision, (Integer)scale, (Boolean)nullable);
                ColumnDefinition column = ColumnDefinition.column((String)columnName, (org.apache.ignite.catalog.ColumnType)columnType);
                columns.add(column);
            }
            ArrayList colocationColumnList = new ArrayList(colocationColumns.values());
            TableDefinition.Builder builder = TableDefinition.builder((QualifiedName)this.tableName).zone(zoneName).columns(columns).colocateBy(colocationColumnList);
            return new TableDefinitionBuilderWithIndexId(builder, indexId);
        });
    }

    private CompletableFuture<TableDefinition.Builder> collectIndexes(TableDefinitionBuilderWithIndexId definition) {
        String query = "SELECT i.index_id, i.index_type, i.index_name, column_name, column_ordinal, column_collation FROM system.indexes i JOIN system.tables t USING (table_id) JOIN system.index_columns ic USING (index_id) WHERE t.schema_name=? AND t.table_name=?ORDER BY index_id, column_ordinal";
        return SelectFromView.collectResults(this.sql, query, Function.identity(), this.tableName.schemaName(), this.tableName.objectName()).thenApply(list -> {
            LinkedHashMap<Integer, List> indexIdColumns = new LinkedHashMap<Integer, List>();
            HashMap<Integer, String> indexNames = new HashMap<Integer, String>();
            HashMap<Integer, IndexType> indexTypes = new HashMap<Integer, IndexType>();
            for (SqlRow sqlRow : list) {
                int indexId = sqlRow.intValue("INDEX_ID");
                String indexName = sqlRow.stringValue("INDEX_NAME");
                String indexType = sqlRow.stringValue("INDEX_TYPE");
                String columnName = sqlRow.stringValue("COLUMN_NAME");
                String columnCollation = sqlRow.stringValue("COLUMN_COLLATION");
                List columns = indexIdColumns.computeIfAbsent(indexId, key -> new ArrayList());
                indexNames.put(indexId, indexName);
                indexTypes.put(indexId, IndexType.valueOf((String)indexType));
                if (columnCollation == null) {
                    columns.add(ColumnSorted.column((String)columnName));
                    continue;
                }
                columns.add(ColumnSorted.column((String)columnName, (SortOrder)SortOrder.valueOf((String)columnCollation)));
            }
            for (Map.Entry entry : indexIdColumns.entrySet()) {
                String name = (String)indexNames.get(entry.getKey());
                IndexType indexType = (IndexType)indexTypes.get(entry.getKey());
                if (Objects.equals(entry.getKey(), definition.indexId)) {
                    definition.builder.primaryKey(indexType, (List)entry.getValue());
                    continue;
                }
                definition.builder.index(name, indexType, (List)entry.getValue());
            }
            return definition.builder;
        });
    }

    private static class TableDefinitionBuilderWithIndexId {
        private final TableDefinition.Builder builder;
        private final int indexId;

        private TableDefinitionBuilderWithIndexId(TableDefinition.Builder builder, int indexId) {
            this.builder = builder;
            this.indexId = indexId;
        }
    }
}

