/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.cluster.unit;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.cluster.unit.UndeployUnitCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.UnitNotFoundException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.rest.client.api.DeploymentApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class UndeployUnitCall
implements Call<UndeployUnitCallInput, String> {
    private final ApiClientFactory clientFactory;

    UndeployUnitCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(UndeployUnitCallInput input) {
        try {
            DeploymentApi api = new DeploymentApi(this.clientFactory.getClient(input.clusterUrl()));
            api.undeployUnit(input.id(), input.version());
            return DefaultCallOutput.success(MessageUiComponent.from(UiElements.done()).render());
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                return DefaultCallOutput.failure(new UnitNotFoundException(input.id(), input.version()));
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

