/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.datastructures;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.DataStructuresRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.internal.U;

public class DataStructuresCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.ATOMIC_INCREMENT, GridRestCommand.ATOMIC_DECREMENT);

    public DataStructuresCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (SUPPORTED_COMMANDS.contains((Object)req.command())) : req.command();
        return this.incrementOrDecrement((DataStructuresRequest)req).chain(new CX1<IgniteInternalFuture<?>, GridRestResponse>(){

            @Override
            public GridRestResponse applyx(IgniteInternalFuture<?> fut) throws IgniteCheckedException {
                GridRestResponse res = new GridRestResponse();
                res.setResponse(fut.get());
                return res;
            }
        });
    }

    private IgniteInternalFuture<?> incrementOrDecrement(final DataStructuresRequest req) {
        assert (req != null);
        assert (req.command() == GridRestCommand.ATOMIC_INCREMENT || req.command() == GridRestCommand.ATOMIC_DECREMENT) : req.command();
        if (req.key() == null) {
            IgniteCheckedException err = new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("key"));
            return new GridFinishedFuture(err);
        }
        if (req.delta() == null) {
            IgniteCheckedException err = new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("delta"));
            return new GridFinishedFuture(err);
        }
        return this.ctx.closure().callLocalSafe(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Long init = req.initial();
                Long delta = req.delta();
                boolean decr = req.command() == GridRestCommand.ATOMIC_DECREMENT;
                String key = (String)req.key();
                IgniteAtomicLong l = DataStructuresCommandHandler.this.ctx.grid().atomicLong(key, init != null ? init : 0L, true);
                return l.addAndGet(decr ? -delta.longValue() : delta);
            }
        }, false);
    }
}

