/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheAffinityConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String function;
    private String mapper;
    private int partitionedBackups;
    private int partitions;
    private Boolean exclNeighbors;

    public VisorCacheAffinityConfiguration() {
    }

    public VisorCacheAffinityConfiguration(CacheConfiguration ccfg) {
        AffinityFunction aff = ccfg.getAffinity();
        this.function = VisorTaskUtils.compactClass(aff);
        this.mapper = VisorTaskUtils.compactClass(ccfg.getAffinityMapper());
        this.partitions = aff.partitions();
        this.partitionedBackups = ccfg.getBackups();
        Method mthd = IgniteUtils.findNonPublicMethod(aff.getClass(), "isExcludeNeighbors", new Class[0]);
        if (mthd != null) {
            try {
                this.exclNeighbors = (Boolean)mthd.invoke((Object)aff, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public String getFunction() {
        return this.function;
    }

    public String getMapper() {
        return this.mapper;
    }

    public int getPartitionedBackups() {
        return this.partitionedBackups;
    }

    public int getPartitions() {
        return this.partitions;
    }

    @Nullable
    public Boolean isExcludeNeighbors() {
        return this.exclNeighbors;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.function);
        U.writeString(out, this.mapper);
        out.writeInt(this.partitionedBackups);
        out.writeInt(this.partitions);
        out.writeObject(this.exclNeighbors);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.function = U.readString(in);
        this.mapper = U.readString(in);
        this.partitionedBackups = in.readInt();
        this.partitions = in.readInt();
        this.exclNeighbors = (Boolean)in.readObject();
    }

    public String toString() {
        return S.toString(VisorCacheAffinityConfiguration.class, this);
    }
}

