/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexRebuildStatusInfoContainer
extends IgniteDataTransferObject {
    public static final String EMPTY_GROUP_NAME = "no_group";
    private static final long serialVersionUID = 0L;
    private String groupName;
    private String cacheName;

    public IndexRebuildStatusInfoContainer() {
    }

    public IndexRebuildStatusInfoContainer(CacheConfiguration cfg) {
        assert (cfg != null);
        this.groupName = cfg.getGroupName() == null ? EMPTY_GROUP_NAME : cfg.getGroupName();
        this.cacheName = cfg.getName();
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.groupName);
        U.writeString(out, this.cacheName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupName = U.readString(in);
        this.cacheName = U.readString(in);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IndexRebuildStatusInfoContainer)) {
            return false;
        }
        IndexRebuildStatusInfoContainer other = (IndexRebuildStatusInfoContainer)o;
        return this.cacheName.equals(other.cacheName) && this.groupName.equals(other.groupName);
    }

    public int hashCode() {
        return this.groupName.hashCode() * 17 + this.cacheName.hashCode() * 37;
    }

    public String groupName() {
        return this.groupName;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String toString() {
        String dfltImpl = S.toString(IndexRebuildStatusInfoContainer.class, this);
        return dfltImpl.substring(IndexRebuildStatusInfoContainer.class.getSimpleName().length() + 2, dfltImpl.length() - 1);
    }

    public static Comparator<IndexRebuildStatusInfoContainer> comparator() {
        return Comparator.comparing(IndexRebuildStatusInfoContainer::groupName).thenComparing(IndexRebuildStatusInfoContainer::cacheName);
    }
}

