/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildNodesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class ShowChildNodesOperator
extends ShowOperator {
    private PartialPath path;
    private int limit = IoTDBDescriptor.getInstance().getConfig().getSchemaQueryFetchSize();
    private int offset = 0;

    public ShowChildNodesOperator(int tokenIntType, PartialPath path) {
        super(tokenIntType);
        this.path = path;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        ShowChildNodesPlan plan = new ShowChildNodesPlan(ShowPlan.ShowContentType.CHILD_NODE, this.path);
        plan.setLimit(this.limit);
        plan.setOffset(this.offset);
        return plan;
    }
}

