/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class KillQuery
extends Statement {
    private final String queryId;

    public KillQuery(String queryId, @Nullable NodeLocation location) {
        super(location);
        this.queryId = queryId;
    }

    public boolean isKillAll() {
        return this.queryId == null;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitKillQuery(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KillQuery killQuery = (KillQuery)o;
        return Objects.equals(this.queryId, killQuery.queryId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queryId);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return KillQuery.sameClass(this, other);
    }

    @Override
    public String toString() {
        return "KILL QUERY " + this.queryId;
    }
}

