/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openjdk.jmh.util.BoundedPriorityQueue;
import org.openjdk.jmh.util.Multiset;

public class Multisets {
    public static <T> List<T> countHighest(Multiset<T> set, int top) {
        Map.Entry pair;
        BoundedPriorityQueue<Map.Entry<T, Long>> q = new BoundedPriorityQueue<Map.Entry<T, Long>>(top, new Comparator<Map.Entry<T, Long>>(){

            @Override
            public int compare(Map.Entry<T, Long> o1, Map.Entry<T, Long> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        q.addAll(set.entrySet());
        ArrayList result = new ArrayList(q.size());
        while ((pair = (Map.Entry)q.poll()) != null) {
            result.add(pair.getKey());
        }
        Collections.reverse(result);
        return result;
    }

    public static <T> List<T> sortedDesc(final Multiset<T> set) {
        ArrayList<T> sorted = new ArrayList<T>();
        sorted.addAll(set.keys());
        Collections.sort(sorted, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Long.compare(set.count(o2), set.count(o1));
            }
        });
        return sorted;
    }
}

