/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import java.util.ListIterator;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.NumberArgument;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.tests.AbstractTest;

public class Size
extends AbstractTest {
    @Override
    protected boolean executeBasic(MailAdapter mail, Arguments arguments, SieveContext context) throws SyntaxException, SieveMailException {
        Argument argument;
        String comparator = null;
        Integer size = null;
        ListIterator<Argument> argumentsIter = arguments.getArgumentList().listIterator();
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof TagArgument) {
            String tag = ((TagArgument)argument).getTag();
            if (tag.equals(":under") || tag.equals(":over")) {
                comparator = tag;
            } else {
                throw context.getCoordinate().syntaxException(new StringBuilder("Found unexpected TagArgument: \"").append(tag).append("\""));
            }
        }
        if (null == comparator) {
            throw context.getCoordinate().syntaxException("Expecting a Tag");
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof NumberArgument) {
            size = ((NumberArgument)argument).getInteger();
        }
        if (null == size) {
            throw context.getCoordinate().syntaxException("Expecting a Number");
        }
        if (argumentsIter.hasNext()) {
            throw context.getCoordinate().syntaxException("Found unexpected argument(s)");
        }
        return this.test(mail, comparator, size);
    }

    protected boolean test(MailAdapter mail, String comparator, int size) throws SieveMailException {
        boolean isTestPassed = false;
        if (comparator.equals(":over")) {
            isTestPassed = this.testOver(mail, size);
        } else if (comparator.equals(":under")) {
            isTestPassed = this.testUnder(mail, size);
        }
        return isTestPassed;
    }

    protected boolean testUnder(MailAdapter mail, int size) throws SieveMailException {
        return mail.getSize() < size;
    }

    protected boolean testOver(MailAdapter mail, int size) throws SieveMailException {
        return mail.getSize() > size;
    }

    @Override
    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
    }
}

