/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;

public class SerializableQuotaUsageValue<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>>
implements Serializable {
    private final Long value;

    public static <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> SerializableQuotaUsageValue<T, U> valueOf(Optional<U> input) {
        return new SerializableQuotaUsageValue<T, QuotaUsageValue>(input.orElse(null));
    }

    private static <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> Long encodeAsLong(U quota) {
        return quota.asLong();
    }

    public SerializableQuotaUsageValue(U value) {
        this(SerializableQuotaUsageValue.encodeAsLong(value));
    }

    SerializableQuotaUsageValue(Long value) {
        this.value = value;
    }

    public Long encodeAsLong() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableQuotaUsageValue) {
            SerializableQuotaUsageValue that = (SerializableQuotaUsageValue)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).toString();
    }
}

