/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.structs.structtypes;

import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.offheap.structs.NoAssist;

public class StructByteString
extends FSTStruct
implements Comparable {
    protected int len = 0;
    protected byte[] chars;

    public StructByteString(int size) {
        this.chars = new byte[size];
        this.len = 0;
    }

    public StructByteString(String init, int size) {
        this.chars = new byte[size];
        this.len = 0;
        this.setString(init);
    }

    public StructByteString(String s2) {
        this.chars = s2.getBytes();
        this.len = s2.length();
    }

    public void setString(String s2) {
        if (s2 == null) {
            this.setLen(0);
            return;
        }
        if (s2.length() > this.charsLen()) {
            throw new RuntimeException("String length exceeds buffer size. String len " + s2.length() + " charsLen:" + this.charsLen());
        }
        for (int i = 0; i < s2.length(); ++i) {
            this.chars(i, (byte)(s2.charAt(i) & 0xFF));
        }
        this.len = s2.length();
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void chars(int i, byte val) {
        this.chars[i] = val;
    }

    public byte chars(int i) {
        return this.chars[i];
    }

    public int compareTo(StructByteString str) {
        int l1 = this.len;
        int l2 = str.getLen();
        int max = Math.min(l1, l2);
        for (int i = 0; i < max; ++i) {
            byte c2;
            byte c1 = this.chars(i);
            if (c1 == (c2 = str.chars(i))) continue;
            return c1 - c2;
        }
        return l1 - l2;
    }

    public int compareToString(String str) {
        int l1 = this.len;
        int l2 = str.length();
        int max = Math.min(l1, l2);
        for (int i = 0; i < max; ++i) {
            char c2;
            char c1 = (char)(this.chars(i) + 256 & 0xFF);
            if (c1 == (c2 = str.charAt(i))) continue;
            return c1 - c2;
        }
        return l1 - l2;
    }

    public int charsLen() {
        return this.chars.length;
    }

    public String toString() {
        byte[] ch = new byte[this.len];
        for (int i = 0; i < this.len; ++i) {
            ch[i] = this.chars(i);
        }
        return new String(ch, 0);
    }

    @Override
    public int hashCode() {
        int l = this.len;
        int h2 = 0;
        if (l > 0) {
            for (int i = 0; i < this.len; ++i) {
                h2 = 31 * h2 + this.chars(i);
            }
        }
        return h2;
    }

    @Override
    @NoAssist
    public boolean equals(Object o) {
        if (o instanceof StructByteString) {
            StructByteString ss = (StructByteString)o;
            if (ss.getLen() != this.getLen()) {
                return false;
            }
            for (int i = 0; i < ss.getLen(); ++i) {
                if (ss.chars(i) == this.chars(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NoAssist
    public int compareTo(Object o) {
        if (o instanceof StructByteString) {
            return this.compareTo((StructByteString)o);
        }
        return -1;
    }

    @Override
    @NoAssist
    public Object getFieldValues() {
        return this.toString();
    }
}

