/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.james.backends.opensearch.json.JsonpDeserializerBase;
import org.apache.james.backends.opensearch.json.JsonpMapperBase;
import org.apache.james.backends.opensearch.json.jackson.JacksonJsonProvider;
import org.apache.james.backends.opensearch.json.jackson.JacksonJsonpGenerator;
import org.apache.james.backends.opensearch.json.jackson.JacksonJsonpParser;
import org.apache.james.backends.opensearch.json.jackson.JacksonUtils;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;

public class JacksonJsonpMapper
extends JsonpMapperBase {
    private final JacksonJsonProvider provider;
    private final ObjectMapper objectMapper;

    public JacksonJsonpMapper(ObjectMapper objectMapper) {
        this(objectMapper, new JsonFactory());
    }

    public JacksonJsonpMapper(ObjectMapper objectMapper, JsonFactory jsonFactory) {
        this.provider = new JacksonJsonProvider(jsonFactory);
        this.objectMapper = objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public JacksonJsonpMapper() {
        this(new ObjectMapper());
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public JsonProvider jsonProvider() {
        return this.provider;
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> clazz) {
        return new JacksonValueParser<T>(clazz);
    }

    public <T> void serialize(T value, JsonGenerator generator) {
        if (!(generator instanceof JacksonJsonpGenerator)) {
            throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
        }
        JsonpSerializer<T> serializer = JacksonJsonpMapper.findSerializer(value);
        if (serializer != null) {
            serializer.serialize(value, generator, (JsonpMapper)this);
            return;
        }
        com.fasterxml.jackson.core.JsonGenerator jkGenerator = ((JacksonJsonpGenerator)generator).jacksonGenerator();
        try {
            this.objectMapper.writeValue(jkGenerator, value);
        }
        catch (IOException ioe) {
            throw JacksonUtils.convertException(ioe);
        }
    }

    private class JacksonValueParser<T>
    extends JsonpDeserializerBase<T> {
        private final Class<T> clazz;

        protected JacksonValueParser(Class<T> clazz) {
            super(EnumSet.allOf(JsonParser.Event.class));
            this.clazz = clazz;
        }

        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (!(parser instanceof JacksonJsonpParser)) {
                throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
            }
            com.fasterxml.jackson.core.JsonParser jkParser = ((JacksonJsonpParser)parser).jacksonParser();
            try {
                return (T)JacksonJsonpMapper.this.objectMapper.readValue(jkParser, this.clazz);
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }
    }
}

