/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGreylistHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGreylistHandler.class);
    private Duration tempBlockTime = Duration.ofHours(1L);
    private Duration autoWhiteListLifeTime = Duration.ofDays(36L);
    private Duration unseenLifeTime = Duration.ofHours(4L);
    private static final HookResult TO_FAST = HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Reconnect to fast. Please try again later").build();
    private static final HookResult TEMPORARY_REJECT = HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Please try again later").build();

    public void setUnseenLifeTime(Duration unseenLifeTime) {
        this.unseenLifeTime = unseenLifeTime;
    }

    public void setAutoWhiteListLifeTime(Duration autoWhiteListLifeTime) {
        this.autoWhiteListLifeTime = autoWhiteListLifeTime;
    }

    public void setTempBlockTime(Duration tempBlockTime) {
        this.tempBlockTime = tempBlockTime;
    }

    private HookResult doGreyListCheck(SMTPSession session, MaybeSender senderAddress, MailAddress recipAddress) {
        String recip = "";
        String sender = senderAddress.asString("");
        if (recipAddress != null) {
            recip = recipAddress.toString();
        }
        Instant time = Instant.now();
        String ipAddress = session.getRemoteAddress().getAddress().getHostAddress();
        try {
            long createTimeStamp = 0L;
            int count = 0;
            Iterator<String> data = this.getGreyListData(ipAddress, sender, recip);
            if (data.hasNext()) {
                createTimeStamp = Long.parseLong(data.next());
                count = Integer.parseInt(data.next());
            }
            LOGGER.debug("Triplet {} | {} | {} -> TimeStamp: {}", new Object[]{ipAddress, sender, recip, createTimeStamp});
            if (createTimeStamp > 0L) {
                Instant acceptTime = Instant.ofEpochMilli(createTimeStamp).plus(this.tempBlockTime);
                if (time.isBefore(acceptTime) && count == 0) {
                    return TO_FAST;
                }
            } else {
                LOGGER.debug("New triplet {} | {} | {}", new Object[]{ipAddress, sender, recip});
                this.insertTriplet(ipAddress, sender, recip, count, time);
                return TEMPORARY_REJECT;
            }
            LOGGER.debug("Update triplet {} | {} | {} -> timestamp: {}", new Object[]{ipAddress, sender, recip, time});
            this.updateTriplet(ipAddress, sender, recip, count, time);
            if (Math.random() > 0.99) {
                LOGGER.debug("Delete old entries");
                this.cleanupAutoWhiteListGreyList(time.minus(this.autoWhiteListLifeTime));
                this.cleanupGreyList(time.minus(this.unseenLifeTime));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error on greylist method: {}", (Object)e.getMessage());
        }
        return HookResult.DECLINED;
    }

    protected abstract Iterator<String> getGreyListData(String var1, String var2, String var3) throws Exception;

    protected abstract void insertTriplet(String var1, String var2, String var3, int var4, Instant var5) throws Exception;

    protected abstract void updateTriplet(String var1, String var2, String var3, int var4, Instant var5) throws Exception;

    protected abstract void cleanupAutoWhiteListGreyList(Instant var1) throws Exception;

    protected abstract void cleanupGreyList(Instant var1) throws Exception;

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            return this.doGreyListCheck(session, sender, rcpt);
        }
        LOGGER.info("IpAddress {} is allowed to send. Skip greylisting.", (Object)session.getRemoteAddress().getAddress().getHostAddress());
        return HookResult.DECLINED;
    }
}

