/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.apache.james.backends.cassandra.init.KeyspaceFactory;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;

public class ClusterFactory {
    public static CqlSession create(ClusterConfiguration configuration, KeyspaceConfiguration keyspaceConfiguration) {
        Preconditions.checkState((configuration.getUsername().isPresent() == configuration.getPassword().isPresent() ? 1 : 0) != 0, (Object)"If you specify username, you must specify password");
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        configuration.getHosts().forEach(server -> sessionBuilder.addContactPoint(InetSocketAddress.createUnresolved(server.getHostName(), server.getPort())));
        configuration.getUsername().ifPresent(username -> configuration.getPassword().ifPresent(password -> sessionBuilder.withAuthCredentials(username, password)));
        sessionBuilder.withLocalDatacenter(configuration.getLocalDC().orElse("datacenter1"));
        ClusterFactory.createKeyspace(keyspaceConfiguration, sessionBuilder);
        sessionBuilder.withKeyspace(keyspaceConfiguration.getKeyspace());
        CqlSession session = (CqlSession)sessionBuilder.build();
        try {
            ClusterFactory.ensureContactable(session);
            return session;
        }
        catch (Exception e) {
            session.close();
            throw e;
        }
    }

    public static CqlSession createWithoutKeyspace(ClusterConfiguration configuration) {
        Preconditions.checkState((configuration.getUsername().isPresent() == configuration.getPassword().isPresent() ? 1 : 0) != 0, (Object)"If you specify username, you must specify password");
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        configuration.getHosts().forEach(server -> sessionBuilder.addContactPoint(InetSocketAddress.createUnresolved(server.getHostName(), server.getPort())));
        configuration.getUsername().ifPresent(username -> configuration.getPassword().ifPresent(password -> sessionBuilder.withAuthCredentials(username, password)));
        sessionBuilder.withLocalDatacenter(configuration.getLocalDC().orElse("datacenter1"));
        CqlSession session = (CqlSession)sessionBuilder.build();
        try {
            ClusterFactory.ensureContactable(session);
            return session;
        }
        catch (Exception e) {
            session.close();
            throw e;
        }
    }

    private static void createKeyspace(KeyspaceConfiguration keyspaceConfiguration, CqlSessionBuilder sessionBuilder) {
        CqlSession cqlSession = (CqlSession)sessionBuilder.build();
        KeyspaceFactory.createKeyspace(keyspaceConfiguration, cqlSession).block();
        cqlSession.forceCloseAsync();
    }

    private static void ensureContactable(CqlSession session) {
        session.execute("SELECT dateof(now()) FROM system.local ;");
    }
}

