/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.events.EventBusName;
import org.apache.james.events.Group;

public class DispatchingFailureGroup
extends Group {
    public static final String DELIMITER = "-";
    private final EventBusName eventBusName;

    public static DispatchingFailureGroup from(String value) {
        Preconditions.checkArgument((boolean)value.startsWith(DispatchingFailureGroup.class.getName() + DELIMITER));
        return new DispatchingFailureGroup(new EventBusName(value.substring(value.indexOf(DELIMITER) + 1)));
    }

    public DispatchingFailureGroup(EventBusName eventBusName) {
        this.eventBusName = eventBusName;
    }

    public EventBusName getEventBusName() {
        return this.eventBusName;
    }

    @Override
    public String asString() {
        return super.asString() + DELIMITER + this.eventBusName.value();
    }

    @Override
    public final boolean equals(Object o) {
        if (o instanceof DispatchingFailureGroup) {
            DispatchingFailureGroup that = (DispatchingFailureGroup)o;
            return Objects.equals(this.eventBusName, that.eventBusName);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.eventBusName);
    }
}

