/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ContentHandlerContext;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.transport.mailets.ICal4JConfigurator;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICalendarParser
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICalendarParser.class);
    private static final Class<Map<String, AttributeValue<byte[]>>> MAP_STRING_BYTES_CLASS = Map.class;
    public static final String SOURCE_ATTRIBUTE_PARAMETER_NAME = "sourceAttribute";
    public static final String DESTINATION_ATTRIBUTE_PARAMETER_NAME = "destinationAttribute";
    public static final String SOURCE_ATTRIBUTE_PARAMETER_DEFAULT_VALUE = "icsAttachments";
    public static final String DESTINATION_ATTRIBUTE_PARAMETER_DEFAULT_VALUE = "calendars";
    private AttributeName sourceAttributeName;
    private AttributeName destinationAttributeName;

    public void init() throws MessagingException {
        String sourceAttributeNameRaw = this.getInitParameter(SOURCE_ATTRIBUTE_PARAMETER_NAME, SOURCE_ATTRIBUTE_PARAMETER_DEFAULT_VALUE);
        if (Strings.isNullOrEmpty((String)sourceAttributeNameRaw)) {
            throw new MessagingException("source attribute cannot be empty");
        }
        this.sourceAttributeName = AttributeName.of((String)sourceAttributeNameRaw);
        String destinationAttributeNameRaw = this.getInitParameter(DESTINATION_ATTRIBUTE_PARAMETER_NAME, DESTINATION_ATTRIBUTE_PARAMETER_DEFAULT_VALUE);
        if (Strings.isNullOrEmpty((String)destinationAttributeNameRaw)) {
            throw new MessagingException("destination attribute cannot be empty");
        }
        this.destinationAttributeName = AttributeName.of((String)destinationAttributeNameRaw);
    }

    @VisibleForTesting
    AttributeName getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    @VisibleForTesting
    AttributeName getDestinationAttributeName() {
        return this.destinationAttributeName;
    }

    public void service(Mail mail) throws MessagingException {
        AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.sourceAttributeName, MAP_STRING_BYTES_CLASS).ifPresent(icsAttachments -> this.addCalendarsToAttribute(mail, (Map<String, AttributeValue<byte[]>>)icsAttachments));
    }

    private void addCalendarsToAttribute(Mail mail, Map<String, AttributeValue<byte[]>> icsAttachments) {
        Map calendars = (Map)icsAttachments.entrySet().stream().flatMap(entry -> this.createCalendar((String)entry.getKey(), (byte[])((AttributeValue)entry.getValue()).getValue())).collect(ImmutableMap.toImmutableMap(Pair::getKey, pair -> AttributeValue.ofUnserializable((Object)pair.getValue())));
        mail.setAttribute(new Attribute(this.destinationAttributeName, AttributeValue.of((Map)calendars)));
    }

    public String getMailetInfo() {
        return "Calendar Parser";
    }

    private Stream<Pair<String, Calendar>> createCalendar(String key, byte[] icsContent) {
        CalendarBuilder builder = new CalendarBuilder((CalendarParser)CalendarParserFactory.getInstance().get(), new ContentHandlerContext().withSupressInvalidProperties(true), TimeZoneRegistryFactory.getInstance().createRegistry());
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(icsContent);
            return Stream.of(Pair.of((Object)key, (Object)builder.build((InputStream)inputStream)));
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while reading input: " + new String(icsContent, StandardCharsets.UTF_8), (Throwable)e);
            }
            return Stream.of(new Pair[0]);
        }
        catch (ParserException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while parsing ICal object: " + new String(icsContent, StandardCharsets.UTF_8), (Throwable)e);
            }
            return Stream.of(new Pair[0]);
        }
    }

    static {
        ICal4JConfigurator.configure();
    }
}

