/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AssuredReplicationServerResultCode {
    COMPLETE(0),
    TIMEOUT(1),
    CONFLICT(2),
    SERVER_SHUTDOWN(3),
    UNAVAILABLE(4),
    DUPLICATE(5);

    private final int intValue;

    private AssuredReplicationServerResultCode(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static AssuredReplicationServerResultCode valueOf(int intValue) {
        for (AssuredReplicationServerResultCode rc : AssuredReplicationServerResultCode.values()) {
            if (rc.intValue != intValue) continue;
            return rc;
        }
        return null;
    }

    @Nullable
    public static AssuredReplicationServerResultCode forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "complete": {
                return COMPLETE;
            }
            case "timeout": {
                return TIMEOUT;
            }
            case "conflict": {
                return CONFLICT;
            }
            case "servershutdown": 
            case "server-shutdown": 
            case "server_shutdown": {
                return SERVER_SHUTDOWN;
            }
            case "unavailable": {
                return UNAVAILABLE;
            }
            case "duplicate": {
                return DUPLICATE;
            }
        }
        return null;
    }
}

