/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.events.DispatchingFailureGroup;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.EventRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EventDeadLettersRedeliverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDeadLettersRedeliverService.class);
    private final Set<EventBus> eventBuses;
    private final EventDeadLetters deadLetters;

    @Inject
    @VisibleForTesting
    public EventDeadLettersRedeliverService(Set<EventBus> eventBuses, EventDeadLetters deadLetters) {
        this.eventBuses = eventBuses;
        this.deadLetters = deadLetters;
    }

    Flux<Task.Result> redeliverEvents(EventRetriever eventRetriever, RunningOptions runningOptions) {
        return runningOptions.limit().applyOnFlux(eventRetriever.retrieveEvents(this.deadLetters)).flatMap(tuple3 -> this.redeliverGroupEvents((Group)tuple3.getT1(), (Event)tuple3.getT2(), (EventDeadLetters.InsertionId)tuple3.getT3()));
    }

    private Mono<Task.Result> redeliverGroupEvents(Group group, Event event, EventDeadLetters.InsertionId insertionId) {
        return this.findEventBus(group).map(eventBus -> eventBus.reDeliver(group, event).then(this.deadLetters.remove(group, insertionId)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error while performing redelivery of event: {} for group: {}", new Object[]{event.getEventId().toString(), group.asString(), e});
            return Mono.just((Object)Task.Result.PARTIAL);
        })).orElseGet(() -> {
            LOGGER.error("No eventBus associated. event: {} for group: {}", (Object)event.getEventId().toString(), (Object)group.asString());
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Optional<EventBus> findEventBus(Group group) {
        if (group instanceof DispatchingFailureGroup) {
            DispatchingFailureGroup dispatchingFailureGroup = (DispatchingFailureGroup)group;
            return this.eventBuses.stream().filter(eventBus -> eventBus.eventBusName().equals((Object)dispatchingFailureGroup.getEventBusName())).findFirst();
        }
        return this.eventBuses.stream().filter(eventBus -> eventBus.listRegisteredGroups().contains(group)).findFirst();
    }

    public static class RunningOptions {
        public static RunningOptions DEFAULT = new RunningOptions(Limit.unlimited());
        private final Limit limit;

        public RunningOptions(Limit limit) {
            this.limit = limit;
        }

        @JsonCreator
        public RunningOptions(@JsonProperty(value="limit") Integer limit) {
            this.limit = Limit.from(Optional.ofNullable(limit));
        }

        @JsonProperty(value="limit")
        public Optional<Integer> limitValue() {
            return this.limit.getLimit();
        }

        public Limit limit() {
            return this.limit;
        }
    }
}

