/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.james.protocols.api.AbstractProtocolTransport;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.protocols.netty.LineHandlerAware;
import org.apache.james.protocols.netty.LineHandlerUpstreamHandler;

public class NettyProtocolTransport
extends AbstractProtocolTransport {
    private final Channel channel;
    private final Encryption encryption;
    private final boolean proxyRequired;

    public NettyProtocolTransport(Channel channel, Encryption encryption, boolean proxyRequired) {
        this.channel = channel;
        this.encryption = encryption;
        this.proxyRequired = proxyRequired;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public String getId() {
        return this.channel.id().toString();
    }

    public boolean isTLSStarted() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    public boolean isStartTLSSupported() {
        return this.encryption != null && this.encryption.isStartTLS();
    }

    public Optional<SSLSession> getSSLSession() {
        return Optional.ofNullable((SslHandler)this.channel.pipeline().get(SslHandler.class)).map(SslHandler::engine).map(SSLEngine::getSession);
    }

    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    public void popLineHandler() {
        LineHandlerAware channelHandler = (LineHandlerAware)this.channel.pipeline().get("coreHandler");
        channelHandler.popLineHandler();
    }

    private void prepareStartTLS() {
        this.channel.pipeline().addFirst("sslHandler", (ChannelHandler)this.encryption.sslHandler());
    }

    protected void writeToClient(byte[] bytes, ProtocolSession session, boolean startTLS) {
        this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes));
        if (startTLS) {
            this.prepareStartTLS();
        }
    }

    protected void close() {
        this.channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void writeToClient(InputStream in, ProtocolSession session, boolean startTLS) {
        if (startTLS) {
            this.prepareStartTLS();
        }
        if (!this.isTLSStarted() && in instanceof FileInputStream) {
            FileChannel fChannel = ((FileInputStream)in).getChannel();
            try {
                this.channel.writeAndFlush((Object)new DefaultFileRegion(fChannel, 0L, fChannel.size()));
            }
            catch (IOException e) {
                this.channel.writeAndFlush((Object)new ChunkedStream((InputStream)new ExceptionInputStream(e)));
            }
            return;
        }
        this.channel.writeAndFlush((Object)new ChunkedStream(in));
    }

    public void setReadable(boolean readable) {
        this.channel.config().setAutoRead(readable);
    }

    public boolean isReadable() {
        return this.channel.config().isAutoRead();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void pushLineHandler(LineHandler<? extends ProtocolSession> overrideCommandHandler, ProtocolSession session) {
        LineHandlerAware channelHandler = (LineHandlerAware)this.channel.pipeline().get("coreHandler");
        channelHandler.pushLineHandler(new LineHandlerUpstreamHandler<ProtocolSession>(session, overrideCommandHandler));
    }

    private static final class ExceptionInputStream
    extends InputStream {
        private final IOException e;

        public ExceptionInputStream(IOException e) {
            this.e = e;
        }

        @Override
        public int read() throws IOException {
            throw this.e;
        }
    }
}

