/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.utils.quotas;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.jmap.core.UnsignedInt$;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.Quota$;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.QuotaId$;
import org.apache.james.jmap.mail.QuotaRoot;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Quotas$;
import org.apache.james.jmap.mail.Quotas$Message$;
import org.apache.james.jmap.mail.Quotas$Storage$;
import org.apache.james.jmap.mail.Value;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.quota.QuotaManager;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\u0004\b\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006I\u0001!\t!\n\u0005\u0006e\u0001!\ta\r\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003c\u0001A\u0011BA\u001a\u0005-\tVo\u001c;b%\u0016\fG-\u001a:\u000b\u0005!I\u0011AB9v_R\f7O\u0003\u0002\u000b\u0017\u0005)Q\u000f^5mg*\u0011A\"D\u0001\u0005U6\f\u0007O\u0003\u0002\u000f\u001f\u0005)!.Y7fg*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\ti\"%D\u0001\u001f\u0015\ty\u0002%A\u0003rk>$\u0018M\u0003\u0002\"\u001b\u00059Q.Y5mE>D\u0018BA\u0012\u001f\u00051\tVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011a\u0002\u0005\u00067\t\u0001\r\u0001\b\u0015\u0003\u0005)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\r%t'.Z2u\u0015\u0005y\u0013a\u00026bW\u0006\u0014H/Y\u0005\u0003c1\u0012a!\u00138kK\u000e$\u0018A\u0004:fiJLWM^3Rk>$\u0018m\u001d\u000b\u0003i\u0015\u00032!N\u001f@\u001b\u00051$BA\u001c9\u0003%\u0001XO\u00197jg\",'O\u0003\u0002\u0019s)\u0011!hO\u0001\u0005G>\u0014XMC\u0001=\u0003\u001d\u0011X-Y2u_JL!A\u0010\u001c\u0003\u000bMkuN\\8\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t[\u0011\u0001B7bS2L!\u0001R!\u0003\rE+x\u000e^1t\u0011\u001515\u00011\u0001H\u0003%\tXo\u001c;b%>|G\u000f\u0005\u0002A\u0011&\u0011\u0011*\u0011\u0002\n#V|G/\u0019*p_RD3aA&U!\r1BJT\u0005\u0003\u001b^\u0011a\u0001\u001e5s_^\u001c\bCA(S\u001b\u0005\u0001&BA)!\u0003%)\u0007pY3qi&|g.\u0003\u0002T!\n\u0001R*Y5mE>DX\t_2faRLwN\\\u0019\u0005=U\u0003\u0017\u0010\u0005\u0002W;:\u0011qk\u0017\t\u00031^i\u0011!\u0017\u0006\u00035N\ta\u0001\u0010:p_Rt\u0014B\u0001/\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q;\u0012'B\u0012bKR4WC\u00012d+\u0005)F!\u00023\u0014\u0005\u0004I'!\u0001+\n\u0005\u0019<\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002i/\u00051A\u000f\u001b:poN\f\"A[7\u0011\u0005YY\u0017B\u00017\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\\9\u000f\u0005Yy\u0017B\u00019\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!A]:\u0003\u0013QC'o\\<bE2,'B\u00019\u0018c\u0015\u0019SO^<i\u001d\t1b/\u0003\u0002i/E\"!EF\fy\u0005\u0015\u00198-\u00197bc\t1c*\u0001\u0007rk>$\u0018\rV8WC2,X-F\u0003}\u0003'\t)\u0003F\u0002~\u0003\u0003\u0001\"\u0001\u0011@\n\u0005}\f%!\u0002,bYV,\u0007BB\u0010\u0005\u0001\u0004\t\u0019\u0001\u0005\u0005\u0002\u0006\u0005-\u0011qBA\u0012\u001b\t\t9AC\u0002\u0002\n\u0001\nQ!\\8eK2LA!!\u0004\u0002\b\t)\u0011+^8uCB!\u0011\u0011CA\n\u0019\u0001!a\u0001\u001a\u0003C\u0002\u0005U\u0011c\u00016\u0002\u0018A1\u0011\u0011DA\u0010\u0003\u001fi!!a\u0007\u000b\u0007}\tiB\u0003\u0002;\u001b%!\u0011\u0011EA\u000e\u0005=\tVo\u001c;b\u0019&l\u0017\u000e\u001e,bYV,\u0007\u0003BA\t\u0003K!q!a\n\u0005\u0005\u0004\tICA\u0001V#\rQ\u00171\u0006\t\t\u00033\ti#a\t\u0002\u0010%!\u0011qFA\u000e\u0005=\tVo\u001c;b+N\fw-\u001a,bYV,\u0017\u0001C1t\u001dVl'-\u001a:\u0015\t\u0005U\u0012q\f\t\u0006-\u0005]\u00121H\u0005\u0004\u0003s9\"AB(qi&|g\u000e\u0005\u0003\u0002>\u0005ec\u0002BA \u0003'rA!!\u0011\u0002R9!\u00111IA(\u001d\u0011\t)%!\u0014\u000f\t\u0005\u001d\u00131\n\b\u00041\u0006%\u0013\"\u0001\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\taQ\"\u0003\u0002;\u0017%!\u0011QKA,\u0003-)fn]5h]\u0016$\u0017J\u001c;\u000b\u0005iZ\u0011\u0002BA.\u0003;\u00121\"\u00168tS\u001etW\rZ%oi*!\u0011QKA,\u0011\u001d\t\t'\u0002a\u0001\u0003G\nQA^1mk\u0016\u0004D!!\u001a\u0002jA1\u0011\u0011DA\u0010\u0003O\u0002B!!\u0005\u0002j\u0011a\u00111NA0\u0003\u0003\u0005\tQ!\u0001\u0002n\t\u0019q\fJ\u0019\u0012\u0007)\fy\u0007E\u0002\u0017\u0003cJ1!a\u001d\u0018\u0005\r\te.\u001f")
public class QuotaReader {
    private final QuotaManager quotaManager;

    public SMono<Quotas> retrieveQuotas(QuotaRoot quotaRoot) throws MailboxException {
        return SMono$.MODULE$.apply(this.quotaManager.getQuotasReactive(quotaRoot.toModel())).map((Function1 & Serializable)quotas -> new Quotas((Map<QuotaId, Quota>)Quotas$.MODULE$.from(QuotaId$.MODULE$.fromQuotaRoot(quotaRoot), Quota$.MODULE$.from((Map<Quotas.Type, Value>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quotas$Storage$.MODULE$), (Object)this.quotaToValue(quotas.getStorageQuota())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quotas$Message$.MODULE$), (Object)this.quotaToValue(quotas.getMessageQuota()))})))))));
    }

    private <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> Value quotaToValue(org.apache.james.mailbox.model.Quota<T, U> quota) {
        return new Value(UnsignedInt$.MODULE$.liftOrThrow(quota.getUsed().asLong()), this.asNumber(quota.getLimit()));
    }

    private Option<Refined<Object, boolean.And<boolean.Not<numeric.Less<Object>>, boolean.Not<numeric.Greater<Object>>>>> asNumber(QuotaLimitValue<?> value) {
        if (value.isUnlimited()) {
            return None$.MODULE$;
        }
        return new Some((Object)new Refined((Object)UnsignedInt$.MODULE$.liftOrThrow(value.asLong())));
    }

    @Inject
    public QuotaReader(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }
}

