/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import jakarta.mail.internet.AddressException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface UserRewritter
extends Serializable {
    public Optional<Username> rewrite(Username var1) throws AddressException, RecipientRewriteTable.ErrorMappingException;

    public static class RegexRewriter
    implements MappingUserRewriter {
        private static final Logger LOGGER = LoggerFactory.getLogger(RegexRewriter.class);
        private static final int REGEX = 0;
        private static final int PARAMETERIZED_STRING = 1;

        @Override
        public UserRewritter generateUserRewriter(String mapping) {
            return oldUser -> {
                try {
                    return this.regexMap(oldUser.asMailAddress(), mapping).map(Username::of);
                }
                catch (PatternSyntaxException e) {
                    LOGGER.error("Exception during regexMap processing: ", (Throwable)e);
                    return Optional.empty();
                }
            };
        }

        public Optional<String> regexMap(MailAddress address, String mapping) {
            ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)':').split((CharSequence)mapping));
            if (parts.size() != 2) {
                throw new PatternSyntaxException("Regex should be formatted as <regular-expression>:<parameterized-string>", mapping, 0);
            }
            Pattern pattern = Pattern.compile((String)parts.get(0));
            Matcher match = pattern.matcher(address.asString());
            if (match.matches()) {
                ImmutableList<String> parameters = this.listMatchingGroups(match);
                return Optional.of(this.replaceParameters((String)parts.get(1), (List<String>)parameters));
            }
            return Optional.empty();
        }

        private ImmutableList<String> listMatchingGroups(Matcher match) {
            return (ImmutableList)IntStream.rangeClosed(1, match.groupCount()).mapToObj(match::group).collect(ImmutableList.toImmutableList());
        }

        private String replaceParameters(String input, List<String> parameters) {
            int i = 1;
            for (String parameter : parameters) {
                input = input.replace("${" + i++ + "}", parameter);
            }
            return input;
        }
    }

    public static class ThrowingRewriter
    implements MappingUserRewriter {
        @Override
        public UserRewritter generateUserRewriter(String mapping) {
            return user -> {
                throw new RecipientRewriteTable.ErrorMappingException(mapping);
            };
        }
    }

    public static class ReplaceRewriter
    implements MappingUserRewriter {
        @Override
        public UserRewritter generateUserRewriter(String mapping) {
            return oldUser -> Optional.of(Username.of((String)mapping));
        }
    }

    public static class DomainRewriter
    implements MappingUserRewriter {
        @Override
        public UserRewritter generateUserRewriter(String mapping) {
            Domain newDomain = Domain.of((String)mapping);
            return oldUser -> Optional.of(Username.fromLocalPartWithDomain((String)oldUser.getLocalPart(), (Domain)newDomain));
        }
    }

    public static interface MappingUserRewriter {
        public UserRewritter generateUserRewriter(String var1);
    }
}

