/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.rest_client;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.opensearch.client.Cancellable;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.ResponseListener;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.NdJsonpSerializable;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.GenericEndpoint;
import org.opensearch.client.transport.GenericSerializable;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportException;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.rest_client.RestClientOptions;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.MissingRequiredPropertyException;

public class RestClientTransport
implements OpenSearchTransport {
    static final ContentType JsonContentType = ContentType.APPLICATION_JSON;
    private final RestClient restClient;
    private final JsonpMapper mapper;
    private final RestClientOptions transportOptions;

    public RestClientTransport(RestClient restClient, JsonpMapper mapper, @Nullable TransportOptions options) {
        this.restClient = restClient;
        this.mapper = mapper;
        this.transportOptions = options == null ? RestClientOptions.initialOptions() : RestClientOptions.of(options);
    }

    public RestClientTransport(RestClient restClient, JsonpMapper mapper) {
        this(restClient, mapper, null);
    }

    public RestClient restClient() {
        return this.restClient;
    }

    public RestClientTransport withRequestOptions(@Nullable TransportOptions options) {
        return new RestClientTransport(this.restClient, this.mapper, options);
    }

    @Override
    public JsonpMapper jsonpMapper() {
        return this.mapper;
    }

    @Override
    public TransportOptions options() {
        return this.transportOptions;
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }

    @Override
    public <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) throws IOException {
        Request clientReq = this.prepareLowLevelRequest(request, endpoint, options);
        Response clientResp = this.restClient.performRequest(clientReq);
        return this.getHighLevelResponse(clientResp, endpoint);
    }

    @Override
    public <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, final Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) {
        Request clientReq = this.prepareLowLevelRequest(request, endpoint, options);
        final RequestFuture future = new RequestFuture();
        final boolean disableRequiredChecks = ApiTypeHelper.requiredPropertiesCheckDisabled();
        future.cancellable = this.restClient.performRequestAsync(clientReq, new ResponseListener(){

            public void onSuccess(Response clientResp) {
                try (ApiTypeHelper.DisabledChecksHandle h = ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck(disableRequiredChecks);){
                    Object response = RestClientTransport.this.getHighLevelResponse(clientResp, endpoint);
                    future.complete(response);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private <RequestT> Request prepareLowLevelRequest(RequestT request, Endpoint<RequestT, ?, ?> endpoint, @Nullable TransportOptions options) {
        RequestOptions restOptions;
        String method = endpoint.method(request);
        String path = endpoint.requestUrl(request);
        Map<String, String> params = endpoint.queryParameters(request);
        Request clientReq = new Request(method, path);
        RequestOptions requestOptions = restOptions = options == null ? this.transportOptions.restClientRequestOptions() : RestClientOptions.of(options).restClientRequestOptions();
        if (restOptions != null) {
            clientReq.setOptions(restOptions);
        }
        clientReq.addParameters(params);
        if (endpoint.hasRequestBody()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ContentType contentType = JsonContentType;
            if (request instanceof NdJsonpSerializable) {
                this.writeNdJson((NdJsonpSerializable)request, baos);
            } else if (request instanceof GenericSerializable) {
                contentType = ContentType.parse((String)((GenericSerializable)request).serialize(baos));
            } else {
                JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
                this.mapper.serialize(request, generator);
                generator.close();
            }
            clientReq.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray(), contentType));
        }
        clientReq.addParameter("ignore", "400,401,403,404,405");
        return clientReq;
    }

    private void writeNdJson(NdJsonpSerializable value, ByteArrayOutputStream baos) {
        Iterator<?> values = value._serializables();
        while (values.hasNext()) {
            Object item = values.next();
            if (item instanceof NdJsonpSerializable && item != value) {
                this.writeNdJson((NdJsonpSerializable)item, baos);
                continue;
            }
            JsonGenerator generator = this.mapper.jsonProvider().createGenerator((OutputStream)baos);
            this.mapper.serialize(item, generator);
            generator.close();
            baos.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResponseT, ErrorT> ResponseT getHighLevelResponse(Response clientResp, Endpoint<?, ResponseT, ErrorT> endpoint) throws IOException {
        int statusCode = clientResp.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            throw new TransportException("Forbidden access", (Throwable)new ResponseException(clientResp));
        }
        if (statusCode == 401) {
            throw new TransportException("Unauthorized access", (Throwable)new ResponseException(clientResp));
        }
        if (endpoint.isError(statusCode)) {
            HttpEntity entity = clientResp.getEntity();
            if (entity == null) {
                throw new TransportException("Expecting a response body, but none was sent", (Throwable)new ResponseException(clientResp));
            }
            if (endpoint instanceof GenericEndpoint) {
                GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
                RequestLine requestLine = clientResp.getRequestLine();
                StatusLine statusLine = clientResp.getStatusLine();
                entity = new BufferedHttpEntity(entity);
                String contentType = null;
                if (entity.getContentType() != null) {
                    contentType = entity.getContentType().getValue();
                }
                InputStream content = entity.getContent();
                try {
                    Object error = rawEndpoint.responseDeserializer(requestLine.getUri(), requestLine.getMethod(), requestLine.getProtocolVersion().getProtocol(), statusLine.getStatusCode(), statusLine.getReasonPhrase(), Arrays.stream(clientResp.getHeaders()).map(h -> new AbstractMap.SimpleEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList()), contentType, content);
                    throw rawEndpoint.exceptionConverter(statusCode, error);
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            JsonpDeserializer<ErrorT> errorDeserializer = endpoint.errorDeserializer(statusCode);
            if (errorDeserializer == null) {
                throw new TransportException("Request failed with status code '" + statusCode + "'", (Throwable)new ResponseException(clientResp));
            }
            entity = new BufferedHttpEntity(entity);
            try {
                InputStream content = entity.getContent();
                JsonParser parser = this.mapper.jsonProvider().createParser(content);
                try {
                    ErrorT error = errorDeserializer.deserialize(parser, this.mapper);
                    throw endpoint.exceptionConverter(statusCode, error);
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (MissingRequiredPropertyException errorEx) {
                ResponseT ResponseT;
                try {
                    ResponseT response;
                    ResponseT = response = this.decodeResponse(statusCode, entity, clientResp, endpoint);
                }
                catch (Exception respEx) {
                    throw new TransportException("Failed to decode error response", (Throwable)new ResponseException(clientResp));
                }
                EntityUtils.consume((HttpEntity)clientResp.getEntity());
                return ResponseT;
            }
        }
        ResponseT ResponseT = this.decodeResponse(statusCode, clientResp.getEntity(), clientResp, endpoint);
        return ResponseT;
        finally {
            EntityUtils.consume((HttpEntity)clientResp.getEntity());
        }
    }

    private <ResponseT> ResponseT decodeResponse(int statusCode, @Nullable HttpEntity entity, Response clientResp, Endpoint<?, ResponseT, ?> endpoint) throws IOException {
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(statusCode));
            return (ResponseT)response;
        }
        if (endpoint instanceof JsonEndpoint) {
            JsonEndpoint jsonEndpoint = (JsonEndpoint)endpoint;
            ResponseT response = null;
            JsonpDeserializer responseParser = jsonEndpoint.responseDeserializer();
            if (responseParser != null) {
                if (entity == null) {
                    throw new TransportException("Expecting a response body, but none was sent", (Throwable)new ResponseException(clientResp));
                }
                InputStream content = entity.getContent();
                try (JsonParser parser = this.mapper.jsonProvider().createParser(content);){
                    response = responseParser.deserialize(parser, this.mapper);
                }
            }
            return response;
        }
        if (endpoint instanceof GenericEndpoint) {
            GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
            String contentType = null;
            InputStream content = null;
            if (entity != null) {
                if (entity.getContentType() != null) {
                    contentType = entity.getContentType().getValue();
                }
                content = entity.getContent();
            }
            RequestLine requestLine = clientResp.getRequestLine();
            StatusLine statusLine = clientResp.getStatusLine();
            return rawEndpoint.responseDeserializer(requestLine.getUri(), requestLine.getMethod(), requestLine.getProtocolVersion().getProtocol(), statusLine.getStatusCode(), statusLine.getReasonPhrase(), Arrays.stream(clientResp.getHeaders()).map(h -> new AbstractMap.SimpleEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList()), contentType, content);
        }
        throw new TransportException("Unhandled endpoint type: '" + endpoint.getClass().getName() + "'");
    }

    private static class RequestFuture<T>
    extends CompletableFuture<T> {
        private volatile Cancellable cancellable;

        private RequestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && this.cancellable != null) {
                this.cancellable.cancel();
            }
            return cancelled;
        }
    }
}

