/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function4;
import org.jooq.JSONArrayNullStep;
import org.jooq.JSONArrayReturningStep;
import org.jooq.QueryPart;
import org.jooq.Row1;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.JSONObject;
import org.jooq.impl.JSONReturning;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONArray<T>
extends AbstractField<T>
implements QOM.JSONArray<T>,
JSONArrayNullStep<T>,
JSONArrayReturningStep<T> {
    final DataType<T> type;
    final QueryPartListView<? extends Field<?>> fields;
    QOM.JSONOnNull onNull;
    DataType<?> returning;

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields) {
        this(type, fields, null, null);
    }

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields, QOM.JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_ARRAY, type);
        this.type = type;
        this.fields = new QueryPartList((Iterable<Field<?>>)fields);
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONArray<T> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public void accept(Context<?> ctx) {
        QueryPartCollectionView<Field<?>> mapped = QueryPartCollectionView.wrap(this.fields).map(JSONEntryImpl.jsonCastMapper(ctx));
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL && !mapped.isEmpty()) {
                    Row1[] rows = Tools.map(this.fields, f -> DSL.row(f), Row1[]::new);
                    Table t = DSL.values(rows).as("t", "a");
                    Field<?> a = t.field("a");
                    ctx.visit(DSL.field(DSL.select(this.getDataType() == SQLDataType.JSON ? DSL.jsonArrayAgg(a) : DSL.jsonbArrayAgg(a)).from((TableLike<?>)t).where(a.isNotNull())));
                    break;
                }
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_BUILD_ARRAY : Names.N_JSONB_BUILD_ARRAY).sql('(').visit(mapped).sql(')');
                break;
            }
            case CLICKHOUSE: {
                if (this.fields.size() > 1) {
                    ctx.visit(DSL.function(Names.N_toJSONString, this.getDataType(), DSL.function(Names.N_TUPLE, SQLDataType.OTHER, Tools.map(this.fields, e -> JSONEntryImpl.jsonCast(ctx, e), Field[]::new))));
                    break;
                }
                ctx.visit(DSL.function(Names.N_toJSONString, this.getDataType(), DSL.array(new QueryPartListView[]{this.fields})));
                break;
            }
            case DUCKDB: 
            case TRINO: {
                if (ctx.family() == SQLDialect.DUCKDB && this.onNull != QOM.JSONOnNull.ABSENT_ON_NULL) {
                    this.acceptStandard(ctx, mapped);
                    break;
                }
                ctx.visit(JSONObject.absentOnNullIf(() -> this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL, e -> e, DSL.array(Tools.map(this.fields, e -> JSONEntryImpl.jsonCast(ctx, e).cast(SQLDataType.JSON)))).cast(SQLDataType.JSON));
                break;
            }
            case MARIADB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                    Field<String> value = DSL.field(Names.N_VALUE, this.getDataType());
                    ctx.visit(DSL.coalesce(DSL.field(DSL.select(DSL.jsonArrayAgg(DSL.function(Names.N_JSON_EXTRACT, this.getDataType(), value, DSL.inline("$")))).from((TableLike<?>)((Object)DSL.jsonTable(this.$onNull(QOM.JSONOnNull.NULL_ON_NULL), DSL.inline("$[*]")).column(value, SQLDataType.JSON).path("$").as(Names.N_T))).where(value.ne(DSL.inline("null"))).and(DSL.rand().isNotNull())), new Field[]{DSL.jsonArray(new Field[0])}));
                    break;
                }
                this.acceptStandard(ctx, mapped);
                break;
            }
            case SQLITE: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                    Field<String> key = DSL.field(Names.N_KEY, SQLDataType.VARCHAR);
                    Field value = DSL.field(Names.N_VALUE, this.getDataType());
                    ctx.visit(DSL.field(DSL.select(DSL.jsonArrayAgg(value).filterWhere(value.isNotNull().and(key.isNotNull()))).from("{0}({1})", Names.N_JSON_TREE, this.$onNull(QOM.JSONOnNull.NULL_ON_NULL))));
                    break;
                }
                this.acceptStandard(ctx, mapped);
                break;
            }
            default: {
                this.acceptStandard(ctx, mapped);
            }
        }
    }

    private final void acceptStandard(Context<?> ctx, QueryPartCollectionView<Field<?>> mapped) {
        JSONNull jsonNull = this.fields.isEmpty() && ctx.family() == SQLDialect.H2 ? new JSONNull(QOM.JSONOnNull.NULL_ON_NULL) : (this.fields.isEmpty() && JSONNull.NO_SUPPORT_NULL_ON_EMPTY.contains((Object)ctx.dialect()) ? new JSONNull(null) : new JSONNull(this.onNull));
        JSONReturning jsonReturning = new JSONReturning(this.returning);
        CustomField jsonArray = CustomField.of(Names.N_JSON_ARRAY, this.getDataType(), c -> c.visit(Names.N_JSON_ARRAY).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{mapped, jsonNull, jsonReturning}).separator("")).sql(')'));
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(jsonArray);
    }

    @Override
    public final DataType<T> $arg1() {
        return this.type;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $arg2() {
        return QOM.unmodifiable(this.fields);
    }

    @Override
    public final QOM.JSONOnNull $arg3() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $arg4() {
        return this.returning;
    }

    @Override
    public final QOM.JSONArray<T> $arg1(DataType<T> newValue) {
        return this.$constructor().apply(newValue, (Collection<Field<?>>)this.$arg2(), this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg2(QOM.UnmodifiableList<? extends Field<?>> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)newValue, this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg3(QOM.JSONOnNull newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)this.$arg2(), newValue, (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg4(DataType<?> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)this.$arg2(), this.$arg3(), newValue);
    }

    @Override
    public final Function4<? super DataType<T>, ? super Collection<? extends Field<?>>, ? super QOM.JSONOnNull, ? super DataType<?>, ? extends QOM.JSONArray<T>> $constructor() {
        return (a1, a2, a3, a4) -> new JSONArray(a1, (Collection<? extends Field<?>>)((Collection<Field<?>>)a2), (QOM.JSONOnNull)((Object)a3), (DataType<?>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONArray) {
            QOM.JSONArray o = (QOM.JSONArray)that;
            return StringUtils.equals(this.$type(), o.$type()) && StringUtils.equals(this.$fields(), o.$fields()) && StringUtils.equals((Object)this.$onNull(), (Object)o.$onNull()) && StringUtils.equals(this.$returning(), o.$returning());
        }
        return super.equals(that);
    }
}

