/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;

class CardinalityCounter
implements RowLocationRetRowSource {
    private RowLocationRetRowSource rowSource;
    private DataValueDescriptor[] prevKey;
    private long[] cardinality;
    private long numRows;

    public CardinalityCounter(RowLocationRetRowSource rowLocationRetRowSource) {
        this.rowSource = rowLocationRetRowSource;
    }

    @Override
    public boolean needsRowLocation() {
        return this.rowSource.needsRowLocation();
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return this.rowSource.needsRowLocationForDeferredCheckConstraints();
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l) throws StandardException {
        this.rowSource.offendingRowLocation(rowLocation, l);
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.rowSource.rowLocation(rowLocation);
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowSource.getNextRowFromRowSource();
        if (dataValueDescriptorArray != null) {
            this.keepCount(dataValueDescriptorArray);
        }
        return dataValueDescriptorArray;
    }

    @Override
    public boolean needsToClone() {
        return this.rowSource.needsToClone();
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return this.rowSource.getValidColumns();
    }

    @Override
    public void closeRowSource() {
        this.rowSource.closeRowSource();
    }

    private DataValueDescriptor[] clone(DataValueDescriptor[] dataValueDescriptorArray) {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i = 0; i < dataValueDescriptorArray.length - 1; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[i].cloneValue(false);
        }
        return dataValueDescriptorArray2;
    }

    public void keepCount(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n;
        int n2 = dataValueDescriptorArray.length - 1;
        ++this.numRows;
        if (this.prevKey == null) {
            this.prevKey = this.clone(dataValueDescriptorArray);
            this.cardinality = new long[dataValueDescriptorArray.length - 1];
            for (int i = 0; i < n2; ++i) {
                this.cardinality[i] = 1L;
            }
            return;
        }
        for (n = 0; n < n2 && !this.prevKey[n].isNull(); ++n) {
            if (this.prevKey[n].compare(dataValueDescriptorArray[n]) == 0) continue;
            this.prevKey = null;
            this.prevKey = this.clone(dataValueDescriptorArray);
            break;
        }
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            this.cardinality[n4] = this.cardinality[n4] + 1L;
        }
    }

    public long[] getCardinality() {
        return this.cardinality;
    }

    public long getRowCount() {
        return this.numRows;
    }
}

