/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class DeliveryRetriesHelper {
    public static final AttributeName DELIVERY_RETRY_COUNT = AttributeName.of((String)"delivery_retry_count");

    public static int retrieveRetries(Mail mail) {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)DELIVERY_RETRY_COUNT, Integer.class).orElse(0);
    }

    public static void initRetries(Mail mail) {
        mail.setAttribute(DeliveryRetriesHelper.makeAttribute(0));
    }

    public static void incrementRetries(Mail mail) {
        mail.setAttribute(DeliveryRetriesHelper.makeAttribute(DeliveryRetriesHelper.retrieveRetries(mail) + 1));
    }

    public static Attribute makeAttribute(Integer value) {
        return new Attribute(DELIVERY_RETRY_COUNT, AttributeValue.of((Integer)value));
    }
}

