/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;

public class InMemoryModSeqProvider
implements ModSeqProvider {
    private final ConcurrentMap<InMemoryId, AtomicLong> map = new ConcurrentHashMap<InMemoryId, AtomicLong>();

    public ModSeq nextModSeq(Mailbox mailbox) {
        return ModSeq.of((long)this.nextModSeq((InMemoryId)mailbox.getMailboxId()));
    }

    public ModSeq nextModSeq(MailboxId mailboxId) {
        return ModSeq.of((long)this.nextModSeq((InMemoryId)mailboxId));
    }

    public ModSeq highestModSeq(Mailbox mailbox) {
        return ModSeq.of((long)this.getHighest((InMemoryId)mailbox.getMailboxId()).get());
    }

    public ModSeq highestModSeq(MailboxId mailboxId) {
        return ModSeq.of((long)this.getHighest((InMemoryId)mailboxId).get());
    }

    private AtomicLong getHighest(InMemoryId id) {
        AtomicLong u;
        AtomicLong modSeq = (AtomicLong)this.map.get(id);
        if (modSeq == null && (u = this.map.putIfAbsent(id, modSeq = new AtomicLong(0L))) != null) {
            modSeq = u;
        }
        return modSeq;
    }

    private long nextModSeq(InMemoryId mailboxId) {
        return this.getHighest(mailboxId).incrementAndGet();
    }
}

