/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.commands;

import java.time.Instant;
import java.util.Objects;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.eventsourcing.Command;
import org.apache.james.mailbox.model.Quota;

public class DetectThresholdCrossing
implements Command {
    private final Username username;
    private final Quota<QuotaCountLimit, QuotaCountUsage> countQuota;
    private final Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
    private final Instant instant;

    public DetectThresholdCrossing(Username username, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Instant instant) {
        this.username = username;
        this.countQuota = countQuota;
        this.sizeQuota = sizeQuota;
        this.instant = instant;
    }

    public Username getUsername() {
        return this.username;
    }

    public Quota<QuotaCountLimit, QuotaCountUsage> getCountQuota() {
        return this.countQuota;
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getSizeQuota() {
        return this.sizeQuota;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public final boolean equals(Object o) {
        if (o instanceof DetectThresholdCrossing) {
            DetectThresholdCrossing that = (DetectThresholdCrossing)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.sizeQuota, that.sizeQuota);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.username, this.countQuota, this.sizeQuota);
    }
}

