/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.futurerelease;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.smtpserver.futurerelease.FutureReleaseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureReleaseMailParameterHook
implements MailParametersHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(FutureReleaseMailParameterHook.class);
    public static final ProtocolSession.AttachmentKey<FutureReleaseParameters.HoldFor> FUTURERELEASE_HOLDFOR = ProtocolSession.AttachmentKey.of((String)"FUTURERELEASE_HOLDFOR", FutureReleaseParameters.HoldFor.class);
    private final Clock clock;

    @Inject
    public FutureReleaseMailParameterHook(Clock clock) {
        this.clock = clock;
    }

    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        if (session.getUsername() == null) {
            LOGGER.debug("Needs to be logged in in order to use future release extension");
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription("Needs to be logged in in order to use future release extension").build();
        }
        try {
            Duration requestedHoldFor = this.evaluateHoldFor(paramName, paramValue);
            if (requestedHoldFor.compareTo(FutureReleaseParameters.MAX_HOLD_FOR_SUPPORTED) > 0) {
                LOGGER.debug("HoldFor is greater than max-future-release-interval or holdUntil exceeded max-future-release-date-time");
                return HookResult.builder().smtpReturnCode("501").hookReturnCode(HookReturnCode.deny()).smtpDescription("HoldFor is greater than max-future-release-interval or holdUntil exceeded max-future-release-date-time").build();
            }
            if (requestedHoldFor.isNegative()) {
                LOGGER.debug("HoldFor value is negative or holdUntil value is before now");
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription("HoldFor value is negative or holdUntil value is before now").build();
            }
            if (session.getAttachment(FUTURERELEASE_HOLDFOR, ProtocolSession.State.Transaction).isPresent()) {
                LOGGER.debug("Mail parameter cannot contains both holdFor and holdUntil parameters");
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription("Mail parameter cannot contains both holdFor and holdUntil parameters").build();
            }
            session.setAttachment(FUTURERELEASE_HOLDFOR, (Object)FutureReleaseParameters.HoldFor.of(requestedHoldFor), ProtocolSession.State.Transaction);
            return HookResult.DECLINED;
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Incorrect syntax when handling FUTURE-RELEASE mail parameter", (Throwable)e);
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription("Incorrect syntax when handling FUTURE-RELEASE mail parameter").build();
        }
    }

    private Duration evaluateHoldFor(String paramName, String paramValue) {
        if (paramName.equals("HOLDFOR")) {
            return Duration.ofSeconds(Long.parseLong(paramValue));
        }
        if (paramName.equals("HOLDUNTIL")) {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.of("Z"));
            Instant now = LocalDateTime.now(this.clock).toInstant(ZoneOffset.UTC);
            return Duration.between(now, ZonedDateTime.parse(paramValue, formatter).toInstant());
        }
        throw new IllegalArgumentException("Invalid parameter name " + paramName);
    }

    public String[] getMailParamNames() {
        return new String[]{"HOLDFOR", "HOLDUNTIL"};
    }
}

