/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import java.nio.charset.StandardCharsets;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.message.Capability;

public interface ImapConstants {
    public static final String OK = "OK";
    public static final byte[] NO = "NO".getBytes(StandardCharsets.US_ASCII);
    public static final String BAD = "BAD";
    public static final String BYE = "BYE";
    public static final byte UNTAGGED = 42;
    public static final byte CONTINUATION = 43;
    public static final byte SP = 32;
    public static final byte[] NIL = "NIL".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] UID = "UID".getBytes(StandardCharsets.US_ASCII);
    public static final byte BYTE_OPENING_PARENTHESIS = 40;
    public static final byte BYTE_CLOSING_PARENTHESIS = 41;
    public static final byte BYTE_DQUOTE = 34;
    public static final byte BYTE_BACK_SLASH = 92;
    public static final byte BYTE_QUESTION = 63;
    public static final byte BYTE_OPEN_SQUARE_BRACKET = 91;
    public static final byte BYTE_CLOSE_SQUARE_BRACKET = 93;
    public static final byte BYTE_OPEN_BRACE = 123;
    public static final byte BYTE_CLOSE_BRACE = 125;
    public static final char DQUOTE = '\"';
    public static final String VERSION = "IMAP4rev1";
    public static final Capability BASIC_CAPABILITIES = Capability.of("IMAP4rev1");
    public static final Capability SUPPORTS_LITERAL_PLUS = Capability.of("LITERAL+");
    public static final Capability SUPPORTS_RFC3348 = Capability.of("CHILDREN");
    public static final Capability SUPPORTS_OBJECTID = Capability.of("OBJECTID");
    public static final Capability SUPPORTS_SAVEDATE = Capability.of("SAVEDATE");
    public static final Capability SUPPORTS_I18NLEVEL_1 = Capability.of("I18NLEVEL=1");
    public static final Capability SUPPORTS_NAMESPACES = Capability.of("NAMESPACE");
    public static final Capability SUPPORTS_STARTTLS = Capability.of("STARTTLS");
    public static final Capability SUPPORTS_IDLE = Capability.of("IDLE");
    public static final Capability SUPPORTS_XLIST = Capability.of("XLIST");
    public static final Capability SUPPORTS_ENABLE = Capability.of("ENABLE");
    public static final Capability SUPPORTS_CONDSTORE = Capability.of("CONDSTORE");
    public static final Capability SUPPORTS_UNSELECT = Capability.of("UNSELECT");
    public static final Capability SUPPORTS_QRESYNC = Capability.of("QRESYNC");
    public static final Capability SUPPORTS_ACL = Capability.of("ACL");
    public static final Capability SUPPORTS_QUOTA = Capability.of("QUOTA");
    public static final Capability SUPPORTS_QUOTA_RES_STORAGE = Capability.of("QUOTA=RES-STORAGE");
    public static final Capability SUPPORTS_QUOTA_RES_MESSAGE = Capability.of("QUOTA=RES-MESSAGE");
    public static final Capability SUPPORTS_MOVE = Capability.of("MOVE");
    public static final Capability SUPPORTS_UIDPLUS = Capability.of("UIDPLUS");
    public static final Capability SUPPORTS_ANNOTATION = Capability.of("METADATA");
    public static final String INBOX_NAME = "INBOX";
    public static final String MIME_TYPE_TEXT = "TEXT";
    public static final String MIME_TYPE_MULTIPART = "MULTIPART";
    public static final String MIME_SUBTYPE_PLAIN = "PLAIN";
    public static final String MIME_TYPE_MESSAGE = "MESSAGE";
    public static final String MIME_SUBTYPE_RFC822 = "RFC822";
    public static final String RFC822_BCC = "Bcc";
    public static final String RFC822_CC = "Cc";
    public static final String RFC822_FROM = "From";
    public static final String RFC822_DATE = "Date";
    public static final String RFC822_SUBJECT = "Subject";
    public static final String RFC822_TO = "To";
    public static final String RFC822_SENDER = "Sender";
    public static final String RFC822_REPLY_TO = "Reply-To";
    public static final String RFC822_IN_REPLY_TO = "In-Reply-To";
    public static final String RFC822_MESSAGE_ID = "Message-ID";
    public static final byte[] NAME_ATTRIBUTE_HAS_CHILDREN = "\\HasChildren".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_HAS_NO_CHILDREN = "\\HasNoChildren".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_SUBSCRIBED = "\\Subscribed".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_NON_EXISTENT = "\\NonExistent".getBytes(StandardCharsets.US_ASCII);
    public static final char BACK_SLASH = '\\';
    public static final String STATUS_UNSEEN = "UNSEEN";
    public static final String STATUS_MAILBOXID = "MAILBOXID";
    public static final String STATUS_UIDVALIDITY = "UIDVALIDITY";
    public static final String STATUS_UIDNEXT = "UIDNEXT";
    public static final String STATUS_RECENT = "RECENT";
    public static final String STATUS_MESSAGES = "MESSAGES";
    public static final String STATUS_APPENDLIMIT = "APPENDLIMIT";
    public static final String STATUS_SIZE = "SIZE";
    public static final String STATUS_DELETED = "DELETED";
    public static final String STATUS_DELETED_STORAGE = "DELETED-STORAGE";
    public static final String STATUS_HIGHESTMODSEQ = "HIGHESTMODSEQ";
    public static final ImapCommand CAPABILITY_COMMAND = ImapCommand.anyStateCommand("CAPABILITY");
    public static final ImapCommand COMPRESS_COMMAND = ImapCommand.anyStateCommand("COMPRESS");
    public static final ImapCommand LOGOUT_COMMAND = ImapCommand.anyStateCommand("LOGOUT");
    public static final ImapCommand NOOP_COMMAND = ImapCommand.anyStateCommand("NOOP");
    public static final ImapCommand ID_COMMAND = ImapCommand.anyStateCommand("ID");
    public static final ImapCommand AUTHENTICATE_COMMAND = ImapCommand.nonAuthenticatedStateCommand("AUTHENTICATE");
    public static final ImapCommand LOGIN_COMMAND = ImapCommand.nonAuthenticatedStateCommand("LOGIN");
    public static final ImapCommand STARTTLS_COMMAND = ImapCommand.nonAuthenticatedStateCommand("STARTTLS");
    public static final ImapCommand APPEND_COMMAND = ImapCommand.authenticatedStateCommand("APPEND");
    public static final ImapCommand CREATE_COMMAND = ImapCommand.authenticatedStateCommand("CREATE");
    public static final ImapCommand DELETE_COMMAND = ImapCommand.authenticatedStateCommand("DELETE");
    public static final ImapCommand ENABLE_COMMAND = ImapCommand.authenticatedStateCommand("ENABLE");
    public static final ImapCommand EXAMINE_COMMAND = ImapCommand.authenticatedStateCommand("EXAMINE");
    public static final ImapCommand IDLE_COMMAND = ImapCommand.authenticatedStateCommand("IDLE");
    public static final ImapCommand LIST_COMMAND = ImapCommand.authenticatedStateCommand("LIST");
    public static final ImapCommand LSUB_COMMAND = ImapCommand.authenticatedStateCommand("LSUB");
    public static final ImapCommand NAMESPACE_COMMAND = ImapCommand.authenticatedStateCommand("NAMESPACE");
    public static final ImapCommand RENAME_COMMAND = ImapCommand.authenticatedStateCommand("RENAME");
    public static final ImapCommand SELECT_COMMAND = ImapCommand.authenticatedStateCommand("SELECT");
    public static final ImapCommand STATUS_COMMAND = ImapCommand.authenticatedStateCommand("STATUS");
    public static final ImapCommand SUBSCRIBE_COMMAND = ImapCommand.authenticatedStateCommand("SUBSCRIBE");
    public static final ImapCommand UNSELECT_COMMAND = ImapCommand.authenticatedStateCommand("UNSELECT");
    public static final ImapCommand UNSUBSCRIBE_COMMAND = ImapCommand.authenticatedStateCommand("UNSUBSCRIBE");
    public static final ImapCommand XLIST_COMMAND = ImapCommand.authenticatedStateCommand("XLIST");
    public static final ImapCommand DELETEACL_COMMAND = ImapCommand.authenticatedStateCommand("DELETEACL");
    public static final ImapCommand LISTRIGHTS_COMMAND = ImapCommand.authenticatedStateCommand("LISTRIGHTS");
    public static final ImapCommand MYRIGHTS_COMMAND = ImapCommand.authenticatedStateCommand("MYRIGHTS");
    public static final ImapCommand GETACL_COMMAND = ImapCommand.authenticatedStateCommand("GETACL");
    public static final ImapCommand SETACL_COMMAND = ImapCommand.authenticatedStateCommand("SETACL");
    public static final ImapCommand GETQUOTA_COMMAND = ImapCommand.authenticatedStateCommand("GETQUOTA");
    public static final ImapCommand GETQUOTAROOT_COMMAND = ImapCommand.authenticatedStateCommand("GETQUOTAROOT");
    public static final ImapCommand SETQUOTA_COMMAND = ImapCommand.authenticatedStateCommand("SETQUOTA");
    public static final ImapCommand GETMETDATA_COMMAND = ImapCommand.authenticatedStateCommand("GETMETADATA");
    public static final ImapCommand SETMETADATA_COMMAND = ImapCommand.authenticatedStateCommand("SETMETADATA");
    public static final ImapCommand CHECK_COMMAND = ImapCommand.selectedStateCommand("CHECK");
    public static final ImapCommand CLOSE_COMMAND = ImapCommand.selectedStateCommand("CLOSE");
    public static final ImapCommand COPY_COMMAND = ImapCommand.selectedStateCommand("COPY");
    public static final ImapCommand EXPUNGE_COMMAND = ImapCommand.selectedStateCommand("EXPUNGE");
    public static final ImapCommand FETCH_COMMAND = ImapCommand.selectedStateCommand("FETCH");
    public static final ImapCommand MOVE_COMMAND = ImapCommand.selectedStateCommand("MOVE");
    public static final ImapCommand SEARCH_COMMAND = ImapCommand.selectedStateCommand("SEARCH");
    public static final ImapCommand STORE_COMMAND = ImapCommand.selectedStateCommand("STORE");
    public static final ImapCommand UID_COMMAND = ImapCommand.selectedStateCommand("UID");
    public static final ImapCommand REPLACE_COMMAND = ImapCommand.selectedStateCommand("REPLACE");
    public static final String ACL_RESPONSE_NAME = "ACL";
    public static final String QUOTA_RESPONSE_NAME = "QUOTA";
    public static final String QUOTAROOT_RESPONSE_NAME = "QUOTAROOT";
    public static final String ANNOTATION_RESPONSE_NAME = "METADATA";
    public static final byte[] NAME_ATTRIBUTE_NOINFERIORS = "\\Noinferiors".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_NOSELECT = "\\Noselect".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_MARKED = "\\Marked".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_ATTRIBUTE_UNMARKED = "\\Unmarked".getBytes(StandardCharsets.US_ASCII);
    public static final String FETCH_RFC822 = "RFC822";
    public static final String FETCH_RFC822_HEADER = "RFC822.HEADER";
    public static final String FETCH_RFC822_TEXT = "RFC822.TEXT";
    public static final byte[] FETCH_BODY_STRUCTURE = "BODYSTRUCTURE".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] FETCH_BODY = "BODY".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] FETCH_MODSEQ = "MODSEQ".getBytes(StandardCharsets.US_ASCII);
    public static final String LINE_END = "\r\n";
    public static final byte[] LINE_END_BYTES = "\r\n".getBytes();
    public static final long MAX_NZ_NUMBER = 0xFFFFFFFFL;
    public static final long MIN_NZ_NUMBER = 1L;
    public static final String STORAGE_QUOTA_RESOURCE = "STORAGE";
    public static final String MESSAGE_QUOTA_RESOURCE = "MESSAGE";
    public static final String EMAILID = "EMAILID";
    public static final String THREADID = "THREADID";
    public static final String SAVEDATE = "SAVEDATE";
}

