/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.URI;
import java.util.Objects;

public class AuthDomain {
    private URI uri;
    private String realm;
    public static final String noRealm = "";

    public AuthDomain(URI uri) {
        this(uri, null);
    }

    private AuthDomain(URI uri, String realm) {
        Objects.requireNonNull(uri);
        this.uri = uri;
        if (realm == null) {
            realm = noRealm;
        }
        this.realm = realm;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getRealm() {
        return this.realm;
    }

    public int hashCode() {
        return Objects.hash(this.realm, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthDomain other = (AuthDomain)obj;
        return Objects.equals(this.realm, other.realm) && Objects.equals(this.uri, other.uri);
    }
}

