/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.concurrent.TimeUnit;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecBuilderAdapter;
import org.apache.jena.sparql.exec.UpdateExecutionAdapter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionBuilderAdapter
implements UpdateExecutionBuilder {
    private final UpdateExecBuilder builder;

    public UpdateExecutionBuilderAdapter(UpdateExecBuilder builder) {
        this.builder = builder;
    }

    public static UpdateExecutionBuilder adapt(UpdateExecBuilder builder) {
        UpdateExecutionBuilder result = builder instanceof UpdateExecBuilderAdapter ? ((UpdateExecBuilderAdapter)builder).getExecBuilder() : new UpdateExecutionBuilderAdapter(builder);
        return result;
    }

    public UpdateExecBuilder getExecBuilder() {
        return this.builder;
    }

    @Override
    public UpdateExecutionBuilder update(UpdateRequest updateRequest) {
        this.builder.update(updateRequest);
        return this;
    }

    @Override
    public UpdateExecutionBuilder update(Update update) {
        this.builder.update(update);
        return this;
    }

    @Override
    public UpdateExecutionBuilder update(String updateRequestString) {
        this.builder.update(updateRequestString);
        return this;
    }

    @Override
    public UpdateExecutionBuilder parseCheck(boolean parseCheck) {
        this.builder.parseCheck(parseCheck);
        return this;
    }

    @Override
    public UpdateExecutionBuilder set(Symbol symbol, Object value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecutionBuilder set(Symbol symbol, boolean value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecutionBuilder context(Context context2) {
        this.builder.context(context2);
        return this;
    }

    @Override
    public UpdateExecutionBuilder substitution(QuerySolution querySolution) {
        Binding binding = BindingLib.toBinding(querySolution);
        this.builder.substitution(binding);
        return this;
    }

    @Override
    public UpdateExecutionBuilder substitution(String varName, RDFNode value) {
        this.builder.substitution(varName, value.asNode());
        return this;
    }

    @Override
    public UpdateExecutionBuilder timeout(long value, TimeUnit timeUnit) {
        this.builder.timeout(value, timeUnit);
        return this;
    }

    @Override
    public UpdateExecution build() {
        return UpdateExecutionAdapter.adapt(this.builder.build());
    }
}

