/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.fuseki.access.GraphFilter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.sys.SystemTDB;
import org.apache.jena.tdb1.sys.TDBInternal;

class GraphFilterTDB1
extends GraphFilter<NodeId> {
    private GraphFilterTDB1(Collection<NodeId> matches, boolean matchDefaultGraph) {
        super(matches, matchDefaultGraph);
    }

    @Override
    public Symbol getContextKey() {
        return SystemTDB.symTupleFilter;
    }

    public static GraphFilterTDB1 graphFilter(DatasetGraph dsg, Collection<Node> namedGraphs, boolean matchDefaultGraph) {
        if (!TDBInternal.isTDB1(dsg)) {
            throw new IllegalArgumentException("DatasetGraph is not TDB1-backed");
        }
        List x = Txn.calculateRead(dsg, () -> {
            NodeTable nt = TDBInternal.getDatasetGraphTDB(dsg).getQuadTable().getNodeTupleTable().getNodeTable();
            return namedGraphs.stream().map(n -> nt.getNodeIdForNode((Node)n)).filter(Objects::nonNull).toList();
        });
        return new GraphFilterTDB1(x, matchDefaultGraph);
    }
}

