/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.io.IOException;
import java.util.function.Function;
import org.apache.jena.atlas.logging.FmtLog;
import org.slf4j.Logger;

class PlatformInfo {
    PlatformInfo() {
    }

    public static void main(String ... args) throws IOException {
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        Function<Long, String> f = PlatformInfo::strNum2;
        System.out.printf("max=%s  total=%s  used=%s  free=%s\n", f.apply(maxMem), f.apply(totalMem), f.apply(usedMem), f.apply(freeMem));
    }

    static void logDetailsSystem(Logger log2) {
        String prefix = "  ";
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        Function<Long, String> f = PlatformInfo::strNum2;
        long pid = PlatformInfo.getProcessId();
        FmtLog.info(log2, "%sMemory: %s", prefix, f.apply(maxMem));
        FmtLog.info(log2, "%sJava:   %s", prefix, System.getProperty("java.version"));
        FmtLog.info(log2, "%sOS:     %s %s %s", prefix, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        if (pid != -1L) {
            FmtLog.info(log2, "%sPID:    %s", prefix, pid);
        }
    }

    static void logDetailsJVM(Logger log2) {
        String prefix = "  ";
        PlatformInfo.logOne(log2, prefix, "java.vendor");
        PlatformInfo.logOne(log2, prefix, "java.home");
        PlatformInfo.logOne(log2, prefix, "java.runtime.version");
        PlatformInfo.logOne(log2, prefix, "java.runtime.name");
        PlatformInfo.logOne(log2, prefix, "user.language");
        PlatformInfo.logOne(log2, prefix, "user.timezone");
        PlatformInfo.logOne(log2, prefix, "user.country");
        PlatformInfo.logOne(log2, prefix, "user.dir");
    }

    private static void logOne(Logger log2, String prefix, String property) {
        if (prefix == null) {
            prefix = "";
        }
        FmtLog.info(log2, "%s%-20s = %s", prefix, property, System.getProperty(property));
    }

    private static long getProcessId() {
        return ProcessHandle.current().pid();
    }

    private static String strNum10(long x) {
        if (x < 1000L) {
            return Long.toString(x);
        }
        if (x < 1000000L) {
            return String.format("%.1fK", (double)x / 1000.0);
        }
        if (x < 1000000000L) {
            return String.format("%.1fM", (double)x / 1000000.0);
        }
        if (x < 1000000000000L) {
            return String.format("%.1fG", (double)x / 1.0E9);
        }
        return String.format("%.1fT", (double)x / 1.0E12);
    }

    private static String strNum2(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1f KiB", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1f MiB", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1f GiB", (double)x / 1.073741824E9);
        }
        return String.format("%.1fTiB", (double)x / 1.099511627776E12);
    }
}

