/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.util.function.Consumer;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecApp;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.exec.QueryExecutionBuilderAdapter;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.exec.ResultSetAdapter;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.UpdateExecutionBuilderAdapter;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionAdapter
implements RDFConnection {
    private final RDFLink other;

    public static RDFConnection adapt(RDFLink link) {
        if (link instanceof RDFLinkAdapter) {
            RDFLinkAdapter adapter = (RDFLinkAdapter)link;
            return adapter.getConnection();
        }
        return new RDFConnectionAdapter(link);
    }

    protected RDFLink get() {
        return this.other;
    }

    public RDFLink getLink() {
        return this.get();
    }

    protected RDFConnectionAdapter(RDFLink conn) {
        this.other = conn;
    }

    @Override
    public void queryResultSet(String queryString, Consumer<ResultSet> resultSetAction) {
        this.get().queryRowSet(queryString, rowSet -> resultSetAction.accept(new ResultSetAdapter((RowSet)rowSet)));
    }

    @Override
    public void queryResultSet(Query query2, Consumer<ResultSet> resultSetAction) {
        this.get().queryRowSet(query2, rowSet -> resultSetAction.accept(new ResultSetAdapter((RowSet)rowSet)));
    }

    @Override
    public Model queryConstruct(String queryString) {
        return LibRDFLink.graph2model(this.get().queryConstruct(queryString));
    }

    @Override
    public Model queryConstruct(Query query2) {
        return LibRDFLink.graph2model(this.get().queryConstruct(query2));
    }

    @Override
    public Model queryDescribe(String queryString) {
        return LibRDFLink.graph2model(this.get().queryDescribe(queryString));
    }

    @Override
    public Model queryDescribe(Query query2) {
        return LibRDFLink.graph2model(this.get().queryDescribe(query2));
    }

    @Override
    public boolean queryAsk(String queryString) {
        return this.get().queryAsk(queryString);
    }

    @Override
    public boolean queryAsk(Query query2) {
        return this.get().queryAsk(query2);
    }

    @Override
    public QueryExecution query(Query query2) {
        return RDFConnectionAdapter.adapt(this.get().query(query2));
    }

    @Override
    public QueryExecution query(String queryString) {
        return RDFConnectionAdapter.adapt(this.get().query(queryString));
    }

    @Override
    public QueryExecutionBuilder newQuery() {
        return QueryExecutionBuilderAdapter.adapt(this.get().newQuery());
    }

    @Override
    public UpdateExecutionBuilder newUpdate() {
        return UpdateExecutionBuilderAdapter.adapt(this.get().newUpdate());
    }

    private static QueryExecution adapt(QueryExec queryExec) {
        if (queryExec instanceof QueryExecApp) {
            QueryExecMod builder = ((QueryExecApp)queryExec).getBuilder();
            Dataset ds = null;
            if (queryExec.getDataset() != null) {
                ds = DatasetFactory.wrap(queryExec.getDataset());
            }
            return QueryExecutionCompat.compatibility(builder, ds, queryExec.getQuery(), queryExec.getQueryString());
        }
        return QueryExecutionAdapter.adapt(queryExec);
    }

    @Override
    public void update(UpdateRequest update2) {
        this.get().update(update2);
    }

    @Override
    public void update(String update2) {
        this.get().update(update2);
    }

    @Override
    public Model fetch() {
        return LibRDFLink.graph2model(this.get().get());
    }

    @Override
    public Model fetch(String graphName) {
        return LibRDFLink.graph2model(this.get().get(LibRDFLink.name(graphName)));
    }

    @Override
    public void load(String graphName, String file) {
        this.get().load(LibRDFLink.name(graphName), file);
    }

    @Override
    public void load(String file) {
        this.get().load(file);
    }

    @Override
    public void load(String graphName, Model model) {
        this.get().load(LibRDFLink.name(graphName), LibRDFLink.model2graph(model));
    }

    @Override
    public void load(Model model) {
        this.get().load(LibRDFLink.model2graph(model));
    }

    @Override
    public void put(String graphName, String file) {
        this.get().put(LibRDFLink.name(graphName), file);
    }

    @Override
    public void put(String file) {
        this.get().put(file);
    }

    @Override
    public void put(String graphName, Model model) {
        this.get().put(LibRDFLink.name(graphName), LibRDFLink.model2graph(model));
    }

    @Override
    public void put(Model model) {
        this.get().put(LibRDFLink.model2graph(model));
    }

    @Override
    public void delete(String graphName) {
        this.get().delete(LibRDFLink.name(graphName));
    }

    @Override
    public void delete() {
        this.get().delete();
    }

    @Override
    public Dataset fetchDataset() {
        return LibRDFLink.asDataset(this.get().getDataset());
    }

    @Override
    public void loadDataset(String file) {
        this.get().loadDataset(file);
    }

    @Override
    public void loadDataset(Dataset dataset) {
        this.get().loadDataset(LibRDFLink.asDatasetGraph(dataset));
    }

    @Override
    public void putDataset(String file) {
        this.get().putDataset(file);
    }

    @Override
    public void putDataset(Dataset dataset) {
        this.get().putDataset(LibRDFLink.asDatasetGraph(dataset));
    }

    @Override
    public boolean isClosed() {
        return this.get().isClosed();
    }

    @Override
    public void close() {
        this.get().close();
    }

    @Override
    public void begin(TxnType type) {
        this.get().begin(type);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.get().begin(readWrite);
    }

    @Override
    public boolean promote(Transactional.Promote mode) {
        return this.get().promote(mode);
    }

    @Override
    public void commit() {
        this.get().commit();
    }

    @Override
    public void abort() {
        this.get().abort();
    }

    @Override
    public void end() {
        this.get().end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.get().transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.get().transactionType();
    }

    @Override
    public boolean isInTransaction() {
        return this.get().isInTransaction();
    }
}

