/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.system.Vocab;
import org.apache.jena.tdb2.assembler.DatasetAssemblerTDB2;
import org.apache.jena.tdb2.assembler.TDB2GraphAssembler;

public class VocabTDB2 {
    private static final String NS = "http://jena.apache.org/2016/tdb#";
    public static final Resource tDatasetTDB = Vocab.type("http://jena.apache.org/2016/tdb#", "DatasetTDB");
    public static final Resource tDatasetTDB2 = Vocab.type("http://jena.apache.org/2016/tdb#", "DatasetTDB2");
    @Deprecated(forRemoval=true)
    public static final Resource tDatasetTDB_alt = Vocab.type("http://jena.apache.org/2016/tdb#", "DatasetTDB");
    public static final Resource tGraphTDB = Vocab.type("http://jena.apache.org/2016/tdb#", "GraphTDB");
    public static final Resource tGraphTDB2 = Vocab.type("http://jena.apache.org/2016/tdb#", "GraphTDB2");
    @Deprecated(forRemoval=true)
    public static final Resource tGraphTDB_alt = Vocab.type("http://jena.apache.org/2016/tdb#", "GraphTDB");
    public static final Property pLocation = Vocab.property("http://jena.apache.org/2016/tdb#", "location");
    public static final Property pUnionDefaultGraph = Vocab.property("http://jena.apache.org/2016/tdb#", "unionDefaultGraph");
    public static final Property pIndex = Vocab.property("http://jena.apache.org/2016/tdb#", "index");
    public static final Property pGraphName1 = Vocab.property("http://jena.apache.org/2016/tdb#", "graphName");
    public static final Property pGraphName2 = Vocab.property("http://jena.apache.org/2016/tdb#", "namedGraph");
    public static final Property pDataset = Vocab.property("http://jena.apache.org/2016/tdb#", "dataset");
    public static final Property pSetting = Vocab.property(VocabTDB2.getURI(), "setting");
    public static final Property pName = Vocab.property(VocabTDB2.getURI(), "name");
    public static final Property pValue = Vocab.property(VocabTDB2.getURI(), "value");
    private static boolean initialized = false;

    public static String getURI() {
        return NS;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        VocabTDB2.registerWith(Assembler.general());
        initialized = true;
    }

    static void registerWith(AssemblerGroup g) {
        AssemblerUtils.registerDataset(tDatasetTDB, new DatasetAssemblerTDB2());
        AssemblerUtils.registerDataset(tDatasetTDB2, new DatasetAssemblerTDB2());
        AssemblerUtils.registerModel(tGraphTDB, new TDB2GraphAssembler());
        AssemblerUtils.registerModel(tGraphTDB2, new TDB2GraphAssembler());
    }

    static {
        VocabTDB2.init();
    }
}

