/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.ResponsibleParty;

final class PropertyComparator
implements Comparator<Method> {
    private static final String IS = "is";
    private static final String GET = "get";
    static final String SET = "set";
    private final Map<Object, Integer> order = new HashMap<Object, Integer>();
    private final Class<?> implementation;

    PropertyComparator(Class<?> implementation, Class<?> standardImpl) {
        PropertyComparator.defineOrder(implementation, this.order);
        if (this.order.isEmpty() && standardImpl != null && !standardImpl.isAssignableFrom(implementation)) {
            implementation = standardImpl;
            PropertyComparator.defineOrder(implementation, this.order);
        }
        this.implementation = implementation;
    }

    private static void defineOrder(Class<?> implementation, Map<Object, Integer> order) {
        do {
            XmlType xml;
            if ((xml = implementation.getAnnotation(XmlType.class)) == null) continue;
            String[] propOrder = xml.propOrder();
            int i = propOrder.length;
            while (--i >= 0) {
                String prop = propOrder[i];
                if ("role".equals(prop) && ResponsibleParty.class.isAssignableFrom(implementation)) continue;
                order.putIfAbsent(prop, order.size());
            }
        } while ((implementation = implementation.getSuperclass()) != null);
    }

    static boolean isDeprecated(Class<?> implementation, Method method) {
        if (method.isAnnotationPresent(Deprecated.class)) {
            return true;
        }
        if (method.getDeclaringClass() == implementation) {
            return false;
        }
        try {
            method = implementation.getMethod(method.getName(), null);
        }
        catch (NoSuchMethodException e2) {
            throw new AssertionError((Object)e2);
        }
        return method.isAnnotationPresent(Deprecated.class);
    }

    @Override
    public int compare(Method m1, Method m2) {
        boolean deprecated = PropertyComparator.isDeprecated(this.implementation, m1);
        if (deprecated != PropertyComparator.isDeprecated(this.implementation, m2)) {
            return deprecated ? 1 : -1;
        }
        int c = this.indexOf(m2) - this.indexOf(m1);
        if (c == 0) {
            UML a1 = m1.getAnnotation(UML.class);
            UML a2 = m2.getAnnotation(UML.class);
            if (a1 != null) {
                if (a2 == null) {
                    return 1;
                }
                c = PropertyComparator.order(a1) - PropertyComparator.order(a2);
                if (c == 0) {
                    c = a1.identifier().compareToIgnoreCase(a2.identifier());
                }
                return c;
            }
            if (a2 != null) {
                return -1;
            }
            c = m1.getName().compareToIgnoreCase(m2.getName());
        }
        return c;
    }

    private static int order(UML uml) {
        Obligation obligation = uml.obligation();
        if (obligation != null) {
            switch (obligation) {
                case MANDATORY: {
                    return 1;
                }
                case CONDITIONAL: {
                    return 2;
                }
                case OPTIONAL: {
                    return 3;
                }
                case FORBIDDEN: {
                    return 4;
                }
            }
        }
        return 5;
    }

    private int indexOf(Method method) {
        Integer index = this.order.get(method);
        if (index == null) {
            UML uml;
            String name = method.getName();
            index = this.order.get(name = PropertyComparator.toPropertyName(name, PropertyComparator.prefix(name).length()));
            if (index == null && ((uml = method.getAnnotation(UML.class)) == null || (index = this.order.get(uml.identifier())) == null)) {
                index = -1;
            }
            this.order.put(method, index);
        }
        return index;
    }

    static String prefix(String name) {
        if (name.startsWith(GET)) {
            return GET;
        }
        if (name.startsWith(IS)) {
            return IS;
        }
        if (name.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    private static boolean isAcronym(String name, int offset) {
        int length = name.length();
        while (offset < length) {
            int c = name.codePointAt(offset);
            if (Character.isLowerCase(c)) {
                return false;
            }
            offset += Character.charCount(c);
        }
        return true;
    }

    static String toPropertyName(String name, int base) {
        int length = name.length();
        if (length > base) {
            int lo;
            int up;
            name = PropertyComparator.isAcronym(name, base) ? name.substring(base) : ((up = name.codePointAt(base)) != (lo = Character.toLowerCase(up)) ? new StringBuilder(length - base).appendCodePoint(lo).append(name, base + Character.charCount(up), length).toString() : name.substring(base));
        }
        return name.intern();
    }
}

