/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.annotation.Annotation;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;

class Utils {
    Utils() {
    }

    static void assertNoArgs(MethodInfo m, Class<?> a) throws InvalidAnnotationException {
        if (m.getParamCount() != 0) {
            throw new InvalidAnnotationException("Method with @{0} annotation cannot have arguments.  Method=''{1}''", a.getSimpleName(), m);
        }
    }

    static void assertReturnNotVoid(MethodInfo m, Class<?> a) throws InvalidAnnotationException {
        ClassInfo rt = m.getReturnType();
        if (rt.is(Void.TYPE)) {
            throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
        }
    }

    static void assertReturnType(MethodInfo m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        ClassInfo rt = m.getReturnType();
        for (Class<?> cc : c) {
            if (!rt.is(cc)) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
    }

    static void assertArgType(MethodInfo m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        Class<?>[] ptt = m.getRawParamTypes();
        if (ptt.length != 1) {
            throw new InvalidAnnotationException("Only one parameter can be passed to method with @{0} annotation.  Method=''{0}''", a.getSimpleName(), m);
        }
        Class<?> rt = ptt[0];
        for (Class<?> cc : c) {
            if (rt != cc) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", a.getSimpleName(), m);
    }
}

