/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.StringUtils;

public class SearchArgs {
    public static SearchArgs DEFAULT = SearchArgs.builder().build();
    private final Map<String, String> search;
    private final List<String> view;
    private final Map<String, Boolean> sort;
    private final int position;
    private final int limit;
    private final boolean ignoreCase;

    SearchArgs(Builder b) {
        this.search = Collections.unmodifiableMap(new LinkedHashMap<String, String>(b.search));
        this.view = Collections.unmodifiableList(new ArrayList<String>(b.view));
        this.sort = Collections.unmodifiableMap(new LinkedHashMap<String, Boolean>(b.sort));
        this.position = b.position;
        this.limit = b.limit;
        this.ignoreCase = b.ignoreCase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getSearch() {
        return this.search;
    }

    public List<String> getView() {
        return this.view;
    }

    public Map<String, Boolean> getSort() {
        return this.sort;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public static final class Builder {
        Map<String, String> search = new LinkedHashMap<String, String>();
        List<String> view = new ArrayList<String>();
        Map<String, Boolean> sort = new LinkedHashMap<String, Boolean>();
        int position;
        int limit;
        boolean ignoreCase;

        public Builder search(String searchTerms) {
            if (searchTerms != null) {
                for (String s : StringUtils.split(searchTerms)) {
                    int i = StringUtils.indexOf(s, '=', '>', '<');
                    if (i == -1) {
                        throw new FormattedRuntimeException("Invalid search terms: ''{0}''", searchTerms);
                    }
                    char c = s.charAt(i);
                    this.search(s.substring(0, i).trim(), s.substring(c == '=' ? i + 1 : i).trim());
                }
            }
            return this;
        }

        public Builder search(String column, String searchTerm) {
            this.search.put(column, searchTerm);
            return this;
        }

        public Builder view(String columns) {
            if (columns != null) {
                return this.view(Arrays.asList(StringUtils.split(columns)));
            }
            return this;
        }

        public Builder view(Collection<String> columns) {
            this.view.addAll(columns);
            return this;
        }

        public Builder sort(String sortArgs) {
            if (sortArgs != null) {
                this.sort(Arrays.asList(StringUtils.split(sortArgs)));
            }
            return this;
        }

        public Builder sort(Collection<String> sortArgs) {
            for (String s : sortArgs) {
                boolean isDesc = false;
                if (StringUtils.endsWith(s, '-', '+')) {
                    isDesc = StringUtils.endsWith(s, '-');
                    s = s.substring(0, s.length() - 1);
                }
                this.sort.put(s, isDesc);
            }
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder ignoreCase(boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public SearchArgs build() {
            return new SearchArgs(this);
        }
    }
}

