/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.SimpleJson;

public class UrlPathInfo {
    final String[] parts;
    final String path;

    public UrlPathInfo(String path) {
        if (path != null && !path.startsWith("/")) {
            throw new RuntimeException("Invalid path specified.  Must be null or start with '/' per HttpServletRequest.getPathInfo().");
        }
        this.path = path;
        this.parts = path == null ? new String[]{} : StringUtils.split((String)path.substring(1), (char)'/');
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = StringUtils.urlDecode((String)this.parts[i]);
        }
    }

    public String[] getParts() {
        return this.parts;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isTrailingSlash() {
        return this.path.endsWith("/");
    }

    public OMap toMap() {
        return new DefaultFilteringOMap().append("raw", (Object)this.path).append("parts", (Object)this.parts);
    }

    public String toString() {
        return SimpleJson.DEFAULT.toString((Object)this.toMap());
    }
}

